/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class MoveDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String POLICY_MOVE_MEMBERS = "org.eclipse.jdt.ui.moveMembers";
    private static final String POLICY_MOVE_PACKAGES = "org.eclipse.jdt.ui.movePackages";
    private static final String POLICY_MOVE_RESOURCES = "org.eclipse.jdt.ui.moveResources";
    private static final String POLICY_MOVE_ROOTS = "org.eclipse.jdt.ui.moveRoots";
    private Object fDestination;
    private IPath[] fFiles;
    private IPath[] fFolders;
    private IPackageFragment[] fFragments;
    private IMember[] fMembers;
    private String fMovePolicy;
    private String fPatterns;
    private boolean fQualified;
    private boolean fReferences;
    private IPackageFragmentRoot[] fRoots;
    private ICompilationUnit[] fUnits;

    public MoveDescriptor() {
        super("org.eclipse.jdt.ui.move");
        this.fMovePolicy = null;
        this.fPatterns = null;
        this.fQualified = false;
        this.fReferences = false;
    }

    public MoveDescriptor(String project, String description, String comment, Map<String, String> arguments, int flags) {
        block17: {
            super("org.eclipse.jdt.ui.move", project, description, comment, arguments, flags);
            this.fMovePolicy = null;
            this.fPatterns = null;
            this.fQualified = false;
            this.fReferences = false;
            this.fMovePolicy = JavaRefactoringDescriptorUtil.getString(this.fArguments, ATTRIBUTE_POLICY);
            this.fDestination = JavaRefactoringDescriptorUtil.getJavaElement(this.fArguments, ATTRIBUTE_DESTINATION, project, true);
            if (this.fDestination == null) {
                this.fDestination = JavaRefactoringDescriptorUtil.getResourcePath(this.fArguments, ATTRIBUTE_TARGET, project);
            }
            if (this.fMovePolicy == null) break block17;
            switch (this.fMovePolicy) {
                case "org.eclipse.jdt.ui.moveResources": {
                    this.fReferences = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, "references", this.fReferences);
                    this.fQualified = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_QUALIFIED, this.fQualified);
                    this.fPatterns = JavaRefactoringDescriptorUtil.getString(this.fArguments, ATTRIBUTE_PATTERNS, true);
                    int offset = 1;
                    this.fFiles = JavaRefactoringDescriptorUtil.getResourcePathArray(this.fArguments, ATTRIBUTE_FILES, "element", offset, project);
                    this.fFolders = JavaRefactoringDescriptorUtil.getResourcePathArray(this.fArguments, ATTRIBUTE_FOLDERS, "element", offset += this.fFiles.length, project);
                    this.fUnits = (ICompilationUnit[])JavaRefactoringDescriptorUtil.getJavaElementArray(this.fArguments, ATTRIBUTE_UNITS, "element", offset += this.fFolders.length, project, ICompilationUnit.class);
                    break;
                }
                case "org.eclipse.jdt.ui.moveRoots": {
                    this.fRoots = (IPackageFragmentRoot[])JavaRefactoringDescriptorUtil.getJavaElementArray(this.fArguments, ATTRIBUTE_ROOTS, "element", 1, project, IPackageFragmentRoot.class);
                    break;
                }
                case "org.eclipse.jdt.ui.movePackages": {
                    this.fFragments = (IPackageFragment[])JavaRefactoringDescriptorUtil.getJavaElementArray(this.fArguments, ATTRIBUTE_FRAGMENTS, "element", 1, project, IPackageFragment.class);
                    break;
                }
                case "org.eclipse.jdt.ui.moveMembers": {
                    this.fMembers = (IMember[])JavaRefactoringDescriptorUtil.getJavaElementArray(this.fArguments, ATTRIBUTE_MEMBERS, "element", 1, project, IMember.class);
                    break;
                }
            }
        }
    }

    @Override
    protected void populateArgumentMap() {
        block19: {
            super.populateArgumentMap();
            JavaRefactoringDescriptorUtil.setString(this.fArguments, ATTRIBUTE_POLICY, this.fMovePolicy);
            String project = this.getProject();
            if (this.fDestination instanceof IJavaElement) {
                JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, ATTRIBUTE_DESTINATION, project, (IJavaElement)this.fDestination);
            } else if (this.fDestination instanceof IPath) {
                JavaRefactoringDescriptorUtil.setResourcePath(this.fArguments, ATTRIBUTE_TARGET, project, (IPath)this.fDestination);
            }
            if (this.fMovePolicy == null) break block19;
            switch (this.fMovePolicy) {
                case "org.eclipse.jdt.ui.moveResources": {
                    JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, "references", this.fReferences);
                    JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_QUALIFIED, this.fQualified);
                    JavaRefactoringDescriptorUtil.setString(this.fArguments, ATTRIBUTE_PATTERNS, this.fPatterns);
                    int offset = 1;
                    JavaRefactoringDescriptorUtil.setResourcePathArray(this.fArguments, ATTRIBUTE_FILES, "element", project, this.fFiles, offset);
                    JavaRefactoringDescriptorUtil.setResourcePathArray(this.fArguments, ATTRIBUTE_FOLDERS, "element", project, this.fFolders, offset += this.fFiles.length);
                    JavaRefactoringDescriptorUtil.setJavaElementArray(this.fArguments, ATTRIBUTE_UNITS, "element", project, (IJavaElement[])this.fUnits, offset += this.fFolders.length);
                    break;
                }
                case "org.eclipse.jdt.ui.moveRoots": {
                    JavaRefactoringDescriptorUtil.setJavaElementArray(this.fArguments, ATTRIBUTE_ROOTS, "element", project, (IJavaElement[])this.fRoots, 1);
                    break;
                }
                case "org.eclipse.jdt.ui.movePackages": {
                    JavaRefactoringDescriptorUtil.setJavaElementArray(this.fArguments, ATTRIBUTE_FRAGMENTS, "element", project, (IJavaElement[])this.fFragments, 1);
                    break;
                }
                case "org.eclipse.jdt.ui.moveMembers": {
                    JavaRefactoringDescriptorUtil.setJavaElementArray(this.fArguments, ATTRIBUTE_MEMBERS, "element", project, (IJavaElement[])this.fMembers, 1);
                    break;
                }
            }
        }
    }

    public void setDestination(IJavaElement element) {
        Assert.isNotNull((Object)element);
        this.fDestination = element;
    }

    public void setDestination(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fDestination = resource.getFullPath();
    }

    public void setFileNamePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        Assert.isLegal((!"".equals(patterns) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = patterns;
    }

    public void setMoveMembers(IMember[] members) {
        Assert.isNotNull((Object)members);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fMembers = members;
        this.fMovePolicy = POLICY_MOVE_MEMBERS;
    }

    public void setMovePackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull((Object)roots);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fRoots = roots;
        this.fMovePolicy = POLICY_MOVE_ROOTS;
    }

    public void setMovePackages(IPackageFragment[] fragments) {
        Assert.isNotNull((Object)fragments);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFragments = fragments;
        this.fMovePolicy = POLICY_MOVE_PACKAGES;
    }

    public void setMoveResources(IFile[] files, IFolder[] folders, ICompilationUnit[] units) {
        Assert.isNotNull((Object)files);
        Assert.isNotNull((Object)folders);
        Assert.isNotNull((Object)units);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFiles = new IPath[files.length];
        int i = 0;
        while (i < files.length) {
            this.fFiles[i] = files[i].getFullPath();
            ++i;
        }
        this.fFolders = new IPath[folders.length];
        i = 0;
        while (i < folders.length) {
            this.fFolders[i] = folders[i].getFullPath();
            ++i;
        }
        this.fUnits = units;
        this.fMovePolicy = POLICY_MOVE_RESOURCES;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fQualified = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (!status.hasFatalError()) {
            if (this.fMovePolicy == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_elements_set));
            }
            if (this.fDestination == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_destination_set));
            }
        }
        return status;
    }
}

