/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class ReferencedProjectScope
implements ISearchScope {
    Set<IPath> paths = new HashSet<IPath>();

    public ReferencedProjectScope(IQ7Project q7Project) {
        this.calculatePaths(q7Project);
    }

    protected void calculatePaths(IQ7Project q7Project) {
        if (q7Project == null) {
            return;
        }
        HashSet<IQ7Project> projects = new HashSet<IQ7Project>();
        try {
            this.collectAllProjects(q7Project, projects);
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
        for (IQ7Project iq7Project : projects) {
            this.paths.add(iq7Project.getPath());
        }
    }

    @Override
    public IPath[] getPaths() {
        return this.paths.toArray(new IPath[this.paths.size()]);
    }

    private void collectAllProjects(IQ7Project q7Project, Set<IQ7Project> projects) throws ModelException {
        if (projects.add(q7Project)) {
            IQ7Project[] iQ7ProjectArray = q7Project.getReferences();
            int n = iQ7ProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7Project ref = iQ7ProjectArray[n2];
                if (projects.add(ref)) {
                    this.collectAllProjects(ref, projects);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean contains(IPath path) {
        for (IPath p : this.paths) {
            if (!p.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }
}

