/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import java.util.List;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;

public class Q7WaitUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startInfo(String kind, String className, Q7WaitInfoRoot root) {
        if (root == null || className == null) {
            return;
        }
        Q7WaitInfoRoot q7WaitInfoRoot = root;
        synchronized (q7WaitInfoRoot) {
            Q7WaitUtils.updateClassName(className, root);
            long currentTime = System.currentTimeMillis();
            Q7WaitInfo info = Q7WaitUtils.findInfo(kind, className, root);
            if (info != null) {
                if (Q7WaitUtils.infoNodeIsOpen(info)) {
                    return;
                }
                root.setTick(root.getTick() + 1L);
                info.setLastTick(root.getTick());
                info.setLastStartTime(currentTime);
                info.setTicks(info.getTicks() + 1L);
                return;
            }
            info = Q7WaitUtils.createInfo(kind, className, root);
            info.setStartTime(currentTime);
            info.setLastStartTime(currentTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishInfo(String kind, String className, Q7WaitInfoRoot root) {
        if (root == null || className == null) {
            return;
        }
        Q7WaitInfoRoot q7WaitInfoRoot = root;
        synchronized (q7WaitInfoRoot) {
            Q7WaitUtils.updateClassName(className, root);
            long currentTime = System.currentTimeMillis();
            Q7WaitInfo info = Q7WaitUtils.findInfo(kind, className, root);
            if (info != null) {
                info.setEndTime(currentTime);
                long duration = info.getEndTime() - info.getLastStartTime();
                info.setDuration(info.getDuration() + duration);
                return;
            }
            info = Q7WaitUtils.createInfo(kind, className, root);
            info.setStartTime(root.getStartTime());
            info.setLastStartTime(currentTime);
            info.setEndTime(currentTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateInfo(String kind, String className, Q7WaitInfoRoot root) {
        if (root == null || className == null) {
            return;
        }
        Q7WaitInfoRoot q7WaitInfoRoot = root;
        synchronized (q7WaitInfoRoot) {
            Q7WaitUtils.updateClassName(className, root);
            long currentTick = root.getTick();
            long currentTime = System.currentTimeMillis();
            Q7WaitInfo info = Q7WaitUtils.findInfo(kind, className, root);
            if (info != null) {
                long lastTick = info.getLastTick();
                if (lastTick == currentTick) {
                    info.setEndTime(currentTime);
                    long duration = info.getEndTime() - info.getLastStartTime();
                    info.setDuration(info.getDuration() + duration);
                }
                root.setTick(root.getTick() + 1L);
                info.setLastTick(root.getTick());
                info.setLastStartTime(currentTime);
                return;
            }
            info = Q7WaitUtils.createInfo(kind, className, root);
            info.setStartTime(currentTime);
            info.setLastStartTime(currentTime);
            info.setEndTime(currentTime);
        }
    }

    private static Q7WaitInfo findInfo(String kind, String className, Q7WaitInfoRoot root) {
        int typeId = Q7WaitUtils.getID(kind, root.getTypesNames());
        int classId = Q7WaitUtils.getID(className, root.getClassNames());
        if (classId == -1 || typeId == -1) {
            return null;
        }
        for (Q7WaitInfo info : root.getInfos()) {
            if (info.getTypeId() != typeId || info.getClassId() != classId) continue;
            return info;
        }
        return null;
    }

    private static Q7WaitInfo createInfo(String kind, String className, Q7WaitInfoRoot root) {
        int typeId = Q7WaitUtils.getID(kind, root.getTypesNames());
        int classId = Q7WaitUtils.getID(className, root.getClassNames());
        if (typeId == -1) {
            typeId = root.getTypesNames().size();
            root.getTypesNames().add((Object)kind);
        }
        if (classId == -1) {
            classId = root.getClassNames().size();
            root.getClassNames().add((Object)className);
        }
        Q7WaitInfo info = InfoFactory.eINSTANCE.createQ7WaitInfo();
        root.getInfos().add((Object)info);
        root.setTick(root.getTick() + 1L);
        info.setTypeId(typeId);
        info.setClassId(classId);
        info.setTicks(1L);
        info.setLastTick(root.getTick());
        return info;
    }

    private static boolean infoNodeIsOpen(Q7WaitInfo info) {
        return info.getLastStartTime() > info.getEndTime();
    }

    private static int getID(String kind, List<String> values) {
        int i = 0;
        while (i < values.size()) {
            String typeName = values.get(i);
            if (typeName.equals(kind)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void updateClassName(String className, Q7WaitInfoRoot info) {
        String methodValue;
        int pos = className.indexOf("$");
        if (pos != -1 && (methodValue = (String)info.getInnerClassMap().get((Object)className)) == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String clName = className.substring(0, pos);
            int i1 = 0;
            while (i1 < stackTrace.length) {
                if (stackTrace[i1].getClassName().startsWith(clName)) {
                    methodValue = String.valueOf(stackTrace[i1].getMethodName()) + ":" + stackTrace[i1].getLineNumber();
                    break;
                }
                if (stackTrace[i1].getClassName().equals("org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer") && stackTrace[i1].getMethodName().equals("exec")) {
                    methodValue = String.valueOf(stackTrace[i1 + 1].getMethodName()) + ":" + stackTrace[i1 + 1].getLineNumber();
                    break;
                }
                ++i1;
            }
            if (methodValue != null) {
                info.getInnerClassMap().put((Object)className, (Object)methodValue);
            }
        }
    }
}

