/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class SWTKeyboard {
    private static final Set<Integer> specialKeys = new HashSet<Integer>();

    static {
        specialKeys.add(0x100000A);
        specialKeys.add(0x100000B);
        specialKeys.add(0x100000C);
        specialKeys.add(0x100000D);
        specialKeys.add(0x100000E);
        specialKeys.add(0x100000F);
        specialKeys.add(0x1000010);
        specialKeys.add(0x1000011);
        specialKeys.add(0x1000012);
        specialKeys.add(0x1000013);
        specialKeys.add(0x1000014);
        specialKeys.add(0x1000015);
        specialKeys.add(127);
        specialKeys.add(0x1000007);
        specialKeys.add(0x1000008);
        specialKeys.add(0x1000005);
        specialKeys.add(0x1000006);
        specialKeys.add(0x1000004);
        specialKeys.add(0x1000002);
        specialKeys.add(0x1000003);
        specialKeys.add(0x1000001);
        specialKeys.add(8);
        specialKeys.add(13);
        specialKeys.add(127);
        specialKeys.add(27);
    }

    public void typeKeys(Widget w, boolean fromDisplay, KeyStroke ... keys) {
        if (w.isDisposed()) {
            return;
        }
        KeyStroke[] keyStrokeArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            if (fromDisplay) {
                KeyStroke[] splittedKeyStrokes = this.splitToKeys(keyStroke).toArray(new KeyStroke[0]);
                this.pressKeys(w, fromDisplay, splittedKeyStrokes);
                this.releaseKeys(w, fromDisplay, this.reverse(splittedKeyStrokes));
            } else {
                Event createEvent = this.createEvent(keyStroke, 0);
                w.notifyListeners(1, createEvent);
                createEvent = this.createEvent(keyStroke, 0);
                w.notifyListeners(2, createEvent);
            }
            ++n2;
        }
    }

    public void pressKeys(Widget w, boolean fromDisplay, KeyStroke ... keys) {
        if (w.isDisposed()) {
            return;
        }
        KeyStroke[] keyStrokeArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            Event createEvent = this.createEvent(keyStroke, 0);
            if (fromDisplay) {
                createEvent.widget = w;
                createEvent.type = 1;
                w.getDisplay().post(createEvent);
            } else {
                w.notifyListeners(1, createEvent);
            }
            ++n2;
        }
    }

    public void releaseKeys(Widget w, boolean fromDisplay, KeyStroke ... keys) {
        if (w.isDisposed()) {
            return;
        }
        KeyStroke[] keyStrokeArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            Event createEvent = this.createEvent(keyStroke, 0);
            if (fromDisplay) {
                createEvent.widget = w;
                createEvent.type = 2;
                w.getDisplay().post(createEvent);
            } else {
                w.notifyListeners(2, createEvent);
            }
            ++n2;
        }
    }

    private char character(KeyStroke key, int modifier) {
        int naturalKey = key.getNaturalKey();
        int mod = key.getModifierKeys();
        char ch = (char)naturalKey;
        if (mod == 131072) {
            ch = Character.toUpperCase(ch);
        }
        if (modifier == 131072) {
            ch = Character.isLowerCase(ch) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
        } else if (modifier != 0) {
            return '\u0000';
        }
        return ch;
    }

    private int keycode(KeyStroke key) {
        int naturalKey = key.getNaturalKey();
        int modifierKeys = key.getModifierKeys();
        if (naturalKey == 0) {
            return modifierKeys;
        }
        return naturalKey;
    }

    public Event createEvent(KeyStroke key, int modifier) {
        Event e = new Event();
        e.keyCode = this.keycode(key);
        e.stateMask = key.getModifierKeys();
        e.character = this.character(key, modifier);
        return e;
    }

    public Event createEvent(int code, int mask, char character) {
        Event e = new Event();
        e.keyCode = code;
        e.stateMask = mask;
        e.character = character;
        return e;
    }

    private KeyStroke[] reverse(KeyStroke ... keys) {
        ArrayList<KeyStroke> copy = new ArrayList<KeyStroke>(Arrays.asList(keys));
        Collections.reverse(copy);
        return copy.toArray(new KeyStroke[0]);
    }

    private static int[] sortModifierKeys(int modifierKeys) {
        IKeyLookup lookup = KeyLookupFactory.getDefault();
        int[] sortedKeys = new int[4];
        int index = 0;
        if ((modifierKeys & lookup.getAlt()) != 0) {
            sortedKeys[index++] = lookup.getAlt();
        }
        if ((modifierKeys & lookup.getCommand()) != 0) {
            sortedKeys[index++] = lookup.getCommand();
        }
        if ((modifierKeys & lookup.getCtrl()) != 0) {
            sortedKeys[index++] = lookup.getCtrl();
        }
        if ((modifierKeys & lookup.getShift()) != 0) {
            sortedKeys[index++] = lookup.getShift();
        }
        return sortedKeys;
    }

    public List<KeyStroke> splitToKeys(KeyStroke keyStroke) {
        int naturalKey;
        int modificationKeys = keyStroke.getModifierKeys();
        ArrayList<KeyStroke> keys = new ArrayList<KeyStroke>();
        if (modificationKeys != 0) {
            int[] sortModifierKeys;
            int[] nArray = sortModifierKeys = SWTKeyboard.sortModifierKeys(modificationKeys);
            int n = sortModifierKeys.length;
            int n2 = 0;
            while (n2 < n) {
                int modifierKey = nArray[n2];
                if (modifierKey != 0) {
                    keys.add(KeyStroke.getInstance((int)modifierKey, (int)0));
                }
                ++n2;
            }
        }
        if ((naturalKey = keyStroke.getNaturalKey()) != 0) {
            keys.add(KeyStroke.getInstance((int)0, (int)keyStroke.getNaturalKey()));
        }
        return keys;
    }
}

