/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.tesla.core.ui.UiPackage;
import org.eclipse.rcptt.tesla.core.ui.impl.UiPackageImpl;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.swt.TeslaSWTMessages;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;

public class PlayerTextUtils {
    private static Map<String, Pattern> matchersCache = new HashMap<String, Pattern>();
    private static final int MATCHERS_CACHE_SIZE = 500;
    private static final boolean DEBUG = false;
    private static final boolean isWindows = Platform.getOS().equals("win32");

    public static String getText(SWTUIElement uiElement) {
        String result = PlayerTextUtils.getRawText(uiElement);
        if (result != null) {
            Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
            String finalResult = widget instanceof Text && (((Text)widget).getStyle() & 2) != 0 ? PlayerTextUtils.replaceMultilines(result) : result.replaceAll("\n|\r", "").trim();
            finalResult = PlayerTextUtils.removeAcceleratorFromText(finalResult);
            return finalResult;
        }
        return result;
    }

    public static String getTrimmedText(SWTUIElement uiElement) {
        String result = PlayerTextUtils.getRawText(uiElement);
        if (result != null) {
            result = result.replaceAll("\n|\r", "").trim();
        }
        return result;
    }

    public static String getTextForVerification(SWTUIElement uiElement) {
        String result = PlayerTextUtils.getRawText(uiElement);
        if (result == null) {
            return "";
        }
        return PlayerTextUtils.replaceMultilinesNoTrim(result);
    }

    public static String replaceMultilines(String result) {
        if (result == null) {
            return null;
        }
        return PlayerTextUtils.replaceMultilinesNoTrim(result).trim();
    }

    public static String unifyMultilines(String result) {
        if (result == null) {
            return null;
        }
        return result.replace("\r\n", "\n").trim();
    }

    public static String replaceMultilinesNoTrim(String result) {
        if (result == null) {
            return null;
        }
        if (Platform.getOS().equals("win32")) {
            return result.replaceAll("\r\n", "\n");
        }
        return result;
    }

    public static String getRawText(SWTUIElement uiElement) {
        Object rawElement = PlayerWrapUtils.unwrap(uiElement);
        String result = null;
        if (rawElement instanceof IWorkbenchPartReference) {
            return ((IWorkbenchPartReference)rawElement).getPartName();
        }
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget == null || widget.isDisposed()) {
            return TeslaSWTMessages.SWTUIPlayer_DisposedControl_RawText;
        }
        if (widget instanceof Decorations) {
            result = ((Decorations)widget).getText();
        }
        if (widget instanceof Button && StringUtils.isEmpty((String)(result = ((Button)widget).getText()))) {
            result = ((Button)widget).getToolTipText();
        }
        if (widget instanceof ToolItem && StringUtils.isEmpty((String)(result = ((ToolItem)widget).getToolTipText()))) {
            result = ((ToolItem)widget).getText();
        }
        if (widget instanceof CoolItem) {
            result = ((CoolItem)widget).getText();
        }
        if (widget instanceof Label) {
            result = ((Label)widget).getText();
        }
        if (widget instanceof CLabel) {
            result = ((CLabel)widget).getText();
        }
        if (widget instanceof Text) {
            result = ((Text)widget).getText();
        }
        if (widget instanceof StyledText) {
            result = ((StyledText)widget).getText();
        }
        if (widget instanceof Combo) {
            result = ((Combo)widget).getText();
        }
        if (widget instanceof CCombo) {
            result = ((CCombo)widget).getText();
        }
        if (widget instanceof Group) {
            result = ((Group)widget).getText();
        }
        if (widget instanceof Link) {
            result = ((Link)widget).getText();
        }
        if (widget instanceof MenuItem) {
            MenuItem menuitem = (MenuItem)widget;
            result = PlayerTextUtils.getMenuText(menuitem.getText());
        }
        if (widget instanceof CTabItem) {
            result = ((CTabItem)widget).getText();
        }
        if (widget instanceof TabItem) {
            result = ((TabItem)widget).getText();
        }
        if (widget instanceof TreeItem) {
            result = ((TreeItem)widget).getText();
        }
        if (widget instanceof TableItem) {
            result = ((TableItem)widget).getText();
        }
        if (widget instanceof Shell) {
            result = ((Shell)widget).getText();
        }
        if (widget instanceof Spinner) {
            result = Double.toString((double)((Spinner)widget).getSelection() / Math.pow(10.0, ((Spinner)widget).getDigits()));
        }
        if (result == null) {
            for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
                String text = ext.getRawText(uiElement);
                if (text == null) continue;
                result = text;
                break;
            }
        }
        return result;
    }

    public static String replaceNonUnicode(String finalResult) {
        if (finalResult == null) {
            return null;
        }
        StringBuilder textResult = new StringBuilder();
        char[] cArray = finalResult.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isISOControl(c) || !Character.isDefined(c)) {
                textResult.append(' ');
            } else {
                textResult.append(c);
            }
            ++n2;
        }
        return textResult.toString();
    }

    public static String escape(String finalResult) {
        if (finalResult == null) {
            return null;
        }
        StringBuilder textResult = new StringBuilder();
        char[] cArray = finalResult.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                textResult.append("\\n");
            } else {
                textResult.append(c);
            }
            ++n2;
        }
        return textResult.toString();
    }

    public static String removeAcceleratorFromText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '\\') {
                builder.append(c);
            }
            if (c != '&') {
                builder.append(c);
            }
            ++i;
        }
        text = builder.toString().trim();
        return text;
    }

    public static String getMenuText(String elementName) {
        int tabIndex = (elementName = PlayerTextUtils.removeAcceleratorFromText(elementName)).indexOf("\t");
        if (tabIndex != -1) {
            elementName = elementName.substring(0, tabIndex);
        }
        return elementName;
    }

    public static String validateRegex(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    public static boolean safeMatches(String item, String pattern) {
        if (pattern == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        try {
            if (matchersCache.size() > 500) {
                matchersCache.clear();
            }
            Pattern compile = null;
            if (matchersCache.containsKey(pattern)) {
                compile = matchersCache.get(pattern);
            }
            if (compile == null) {
                compile = Pattern.compile(pattern);
                matchersCache.put(pattern, compile);
            }
            Matcher matcher = compile.matcher(item);
            return matcher.matches();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getDateTimeValue(DateTime dt) {
        return PlayerTextUtils.getDateValue(dt) + " " + PlayerTextUtils.getTimeValue(dt);
    }

    public static String getTimeValue(DateTime dt) {
        return dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();
    }

    public static String getDateValue(DateTime dt) {
        return dt.getYear() + "/" + (dt.getMonth() + 1) + "/" + dt.getDay();
    }

    public static void squashRanges(List<StyleRangeEntry> ranges) {
        Iterator<StyleRangeEntry> i = ranges.iterator();
        StyleRangeEntry next = null;
        while (i.hasNext()) {
            RangeEquality rangeEquality;
            StyleRangeEntry prev = next;
            next = i.next();
            if (prev == null || next.getStart() != prev.getStart() + prev.getLength() || !(rangeEquality = new RangeEquality()).equals((EObject)prev, (EObject)next)) continue;
            prev.setLength(prev.getLength() + next.getLength());
            prev.setEndPos(next.getEndPos());
            i.remove();
        }
    }

    public static List<StyleRangeEntry> captureStyleRanges(StyledText widget) {
        ArrayList<StyleRangeEntry> result = new ArrayList<StyleRangeEntry>();
        StyledText styledText = widget;
        int totalDelta = 0;
        StyleRange[] styleRangeArray = styledText.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange r = styleRangeArray[n2];
            int delta = PlayerTextUtils.countLineEndingConversions(styledText.getTextRange(r.start, r.length));
            StyleRangeEntry rangeEntry = SWTModelMapper.makeStyleRangeEntry(r, r.start - totalDelta, r.length - delta);
            rangeEntry.setStartPos(SWTModelMapper.offsetToPosition(widget, r.start));
            result.add(rangeEntry);
            totalDelta += delta;
            ++n2;
        }
        return result;
    }

    private static int countLineEndingConversions(String text) {
        if (!isWindows) {
            return 0;
        }
        return PlayerTextUtils.countOccurrencesOfString(text, "\r\n");
    }

    private static int countOccurrencesOfString(String text, String substring) {
        int index = 0;
        int count = 0;
        while ((index = text.indexOf(substring, index)) != -1) {
            ++count;
            index += substring.length();
        }
        return count;
    }

    private static final class RangeEquality
    extends EcoreUtil.EqualityHelper {
        private static final long serialVersionUID = 290959129375407943L;
        private static final EStructuralFeature[] ignoredFields;

        static {
            UiPackage pkg = UiPackageImpl.init();
            ignoredFields = new EStructuralFeature[]{pkg.getStyleRangeEntry_Start(), pkg.getStyleRangeEntry_Length(), pkg.getStyleRangeEntry_StartPos(), pkg.getStyleRangeEntry_EndPos()};
        }

        private RangeEquality() {
        }

        protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature featureArg) {
            EStructuralFeature[] eStructuralFeatureArray = ignoredFields;
            int n = ignoredFields.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (this.equals((EObject)feature, (EObject)featureArg)) {
                    return true;
                }
                ++n2;
            }
            return super.haveEqualFeature(eObject1, eObject2, featureArg);
        }
    }
}

