/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.site.AbstractSiteModel;
import org.eclipse.pde.internal.core.site.Site;

public class WorkspaceSiteModel
extends AbstractSiteModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private boolean fDirty;
    private final IFile fFile;
    private boolean fEditable = true;

    public WorkspaceSiteModel(IFile file) {
        this.fFile = file;
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    protected NLResourceHelper createNLResourceHelper() {
        try {
            IPath path = this.fFile.getLocation().removeLastSegments(1);
            Object installLocation = path.toOSString();
            if (!((String)installLocation).startsWith("file:")) {
                installLocation = "file:" + (String)installLocation;
            }
            URL url = new URL((String)installLocation + "/");
            String name = "site";
            NLResourceHelper helper = new NLResourceHelper(name, new URL[]{url});
            return helper;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.setLoaded(true);
        this.save(writer);
        writer.flush();
        return swriter.toString();
    }

    public IFile getFile() {
        return this.fFile;
    }

    @Override
    public String getInstallLocation() {
        return this.fFile.getParent().getLocation().toOSString();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    @Override
    public void load() {
        if (this.fFile.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedInputStream stream = new BufferedInputStream(this.fFile.getContents(true));){
                    if (((InputStream)stream).available() > 0) {
                        this.load(stream, false);
                    } else {
                        this.setLoaded(true);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {}
        } else {
            this.site = new Site();
            this.site.model = this;
            this.setLoaded(true);
        }
    }

    @Override
    public void save() {
        String contents = WorkspaceSiteModel.fixLineDelimiter(this.getContents(), this.fFile);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
                if (this.fFile.exists()) {
                    this.fFile.setContents((InputStream)stream, false, false, null);
                } else {
                    this.fFile.create((InputStream)stream, false, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.site.write("", writer);
        }
        this.setDirty(false);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.fEditable = newEditable;
    }
}

