/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class MemberCheckUtil {
    private MemberCheckUtil() {
    }

    public static RefactoringStatus checkMembersInDestinationType(IMember[] members, IType destinationType) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member.getElementType() == 9) {
                MemberCheckUtil.checkMethodInType(destinationType, result, (IMethod)member);
            } else if (member.getElementType() == 8) {
                MemberCheckUtil.checkFieldInType(destinationType, result, (IField)member);
            } else if (member.getElementType() == 7) {
                MemberCheckUtil.checkTypeInType(destinationType, result, (IType)member);
            }
            ++n2;
        }
        return result;
    }

    private static void checkMethodInType(IType destinationType, RefactoringStatus result, IMethod method) throws JavaModelException {
        IMethod[] destinationTypeMethods = destinationType.getMethods();
        IMethod found = MemberCheckUtil.findMethod(method, destinationTypeMethods);
        if (found != null) {
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), found.getSourceRange());
            String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_signature_exists, new String[]{BasicElementLabels.getJavaElementName(method.getElementName()), MemberCheckUtil.getQualifiedLabel(destinationType)});
            result.addError(message, context);
        } else {
            IMethod similar = Checks.findMethod(method, destinationType);
            if (similar != null) {
                String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_same_param_count, new String[]{BasicElementLabels.getJavaElementName(method.getElementName()), MemberCheckUtil.getQualifiedLabel(destinationType)});
                RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), similar.getSourceRange());
                result.addWarning(message, context);
            }
        }
    }

    private static void checkFieldInType(IType destinationType, RefactoringStatus result, IField field) throws JavaModelException {
        IField destinationTypeField = destinationType.getField(field.getElementName());
        if (!destinationTypeField.exists()) {
            return;
        }
        String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_field_exists, new String[]{BasicElementLabels.getJavaElementName(field.getElementName()), MemberCheckUtil.getQualifiedLabel(destinationType)});
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationTypeField.getSourceRange());
        result.addError(message, context);
    }

    private static void checkTypeInType(IType destinationType, RefactoringStatus result, IType type) throws JavaModelException {
        String typeName = type.getElementName();
        IType destinationTypeType = destinationType.getType(typeName);
        if (destinationTypeType.exists()) {
            String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict0, new String[]{BasicElementLabels.getJavaElementName(typeName), MemberCheckUtil.getQualifiedLabel(destinationType)});
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationTypeType.getNameRange());
            result.addError(message, context);
        } else {
            RefactoringStatusContext context;
            String message;
            if (destinationType.getElementName().equals(typeName)) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict1, MemberCheckUtil.getQualifiedLabel(type));
                context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(destinationType, typeName)) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict2, MemberCheckUtil.getQualifiedLabel(type));
                context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            MemberCheckUtil.checkHierarchyOfEnclosedTypes(destinationType, result, type);
        }
    }

    private static void checkHierarchyOfEnclosedTypes(IType destinationType, RefactoringStatus result, IType type) throws JavaModelException {
        IType[] iTypeArray = MemberCheckUtil.getAllEnclosedTypes(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringStatusContext context;
            String message;
            IType enclosedType = iTypeArray[n2];
            if (destinationType.getElementName().equals(enclosedType.getElementName())) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict3, new String[]{MemberCheckUtil.getQualifiedLabel(enclosedType), MemberCheckUtil.getQualifiedLabel(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(destinationType, enclosedType.getElementName())) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict4, new String[]{MemberCheckUtil.getQualifiedLabel(enclosedType), MemberCheckUtil.getQualifiedLabel(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getCompilationUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            ++n2;
        }
    }

    private static String getQualifiedLabel(IType enclosedType) {
        return BasicElementLabels.getJavaElementName(enclosedType.getFullyQualifiedName('.'));
    }

    private static IType[] getAllEnclosedTypes(IType type) throws JavaModelException {
        ArrayList<IType> result = new ArrayList<IType>(2);
        IType[] directlyEnclosed = type.getTypes();
        result.addAll(Arrays.asList(directlyEnclosed));
        IType[] iTypeArray = directlyEnclosed;
        int n = directlyEnclosed.length;
        int n2 = 0;
        while (n2 < n) {
            IType enclosedType = iTypeArray[n2];
            result.addAll(Arrays.asList(MemberCheckUtil.getAllEnclosedTypes(enclosedType)));
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static boolean typeNameExistsInEnclosingTypeChain(IType type, String typeName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (enclosing.getElementName().equals(typeName)) {
                return true;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return false;
    }

    public static IMethod findMethod(IMethod method, IMethod[] allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        IMethod[] iMethodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, m)) {
                return m;
            }
            ++n2;
        }
        return null;
    }
}

