/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.makestatic;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;

public class ContextCalculator {
    private SelectionInputType fSelectionInputType;
    private Selection fSelectionEditorText;
    private ICompilationUnit fSelectionICompilationUnit;
    private CompilationUnit fSelectionCompilationUnit;
    private ASTNode fSelectionASTNode;
    private IMethodBinding fTargetIMethodBinding;
    private IMethod fTargetIMethod;
    private ICompilationUnit fTargetICompilationUnit;
    private CompilationUnit fTargetCompilationUnit;
    private MethodDeclaration fTargetMethodDeclaration;

    public ContextCalculator(ICompilationUnit inputAsICompilationUnit, Selection targetSelection) {
        this.fSelectionInputType = SelectionInputType.TEXT_SELECTION;
        this.fSelectionEditorText = targetSelection;
        this.fSelectionICompilationUnit = inputAsICompilationUnit;
    }

    public ContextCalculator(IMethod method) {
        this.fSelectionInputType = SelectionInputType.IMETHOD;
        this.fTargetIMethod = method;
    }

    public SelectionInputType getSelectionInputType() {
        return this.fSelectionInputType;
    }

    public Selection getSelectionEditorText() {
        return this.fSelectionEditorText;
    }

    public ICompilationUnit getSelectionICompilationUnit() {
        return this.fSelectionICompilationUnit;
    }

    public ASTNode getOrComputeSelectionASTNode() {
        if (this.fSelectionASTNode == null) {
            this.calculateSelectionASTNode();
        }
        return this.fSelectionASTNode;
    }

    public IMethodBinding getOrComputeTargetIMethodBinding() {
        if (this.fTargetIMethodBinding == null) {
            this.calculateTargetIMethodBinding();
        }
        return this.fTargetIMethodBinding;
    }

    public IMethod getOrComputeTargetIMethod() {
        if (this.fTargetIMethod == null) {
            this.calculateTargetIMethod();
        }
        return this.fTargetIMethod;
    }

    public ICompilationUnit getOrComputeTargetICompilationUnit() {
        if (this.fTargetICompilationUnit == null) {
            this.calculateTargetICompilationUnit();
        }
        return this.fTargetICompilationUnit;
    }

    public CompilationUnit getOrComputeTargetCompilationUnit() {
        if (this.fTargetCompilationUnit == null) {
            this.calculateTargetCompilationUnit();
        }
        return this.fTargetCompilationUnit;
    }

    public MethodDeclaration getOrComputeTargetMethodDeclaration() throws JavaModelException {
        if (this.fTargetMethodDeclaration == null) {
            this.calculateMethodDeclaration();
        }
        return this.fTargetMethodDeclaration;
    }

    private void calculateSelectionASTNode() {
        ICompilationUnit selectionICompilationUnit = this.getSelectionICompilationUnit();
        Selection selectionEditorText = this.getSelectionEditorText();
        if (selectionICompilationUnit == null || selectionEditorText == null) {
            return;
        }
        this.fSelectionCompilationUnit = ContextCalculator.convertICompilationUnitToCompilationUnit(selectionICompilationUnit);
        ASTNode selectionASTNode = NodeFinder.perform((ASTNode)this.fSelectionCompilationUnit, (int)selectionEditorText.getOffset(), (int)selectionEditorText.getLength());
        if (selectionASTNode == null) {
            return;
        }
        this.fSelectionASTNode = selectionASTNode.getNodeType() == 42 ? selectionASTNode.getParent() : (selectionASTNode.getNodeType() == 21 ? ((ExpressionStatement)selectionASTNode).getExpression() : selectionASTNode);
    }

    private void calculateTargetIMethodBinding() {
        ASTNode selectionASTNode = this.getOrComputeSelectionASTNode();
        if (selectionASTNode == null) {
            return;
        }
        if (selectionASTNode instanceof MethodInvocation) {
            MethodInvocation selectionMethodInvocation = (MethodInvocation)selectionASTNode;
            this.fTargetIMethodBinding = selectionMethodInvocation.resolveMethodBinding();
        } else if (selectionASTNode instanceof MethodDeclaration) {
            MethodDeclaration selectionMethodDeclaration = (MethodDeclaration)selectionASTNode;
            this.fTargetIMethodBinding = selectionMethodDeclaration.resolveBinding();
        }
    }

    private void calculateTargetIMethod() {
        IMethodBinding targetIMethodBinding = this.getOrComputeTargetIMethodBinding();
        if (targetIMethodBinding == null) {
            return;
        }
        this.fTargetIMethod = (IMethod)targetIMethodBinding.getJavaElement();
    }

    private void calculateTargetICompilationUnit() {
        IMethod targetIMethod = this.getOrComputeTargetIMethod();
        if (targetIMethod == null) {
            return;
        }
        this.fTargetICompilationUnit = targetIMethod.getDeclaringType().getCompilationUnit();
    }

    private void calculateTargetCompilationUnit() {
        ICompilationUnit targetICompilationUnit = this.getOrComputeTargetICompilationUnit();
        if (targetICompilationUnit == null) {
            return;
        }
        this.fTargetCompilationUnit = ContextCalculator.convertICompilationUnitToCompilationUnit(targetICompilationUnit);
    }

    private void calculateMethodDeclaration() throws JavaModelException {
        IMethod targetIMethod = this.getOrComputeTargetIMethod();
        CompilationUnit targetCompilationUnit = this.getOrComputeTargetCompilationUnit();
        if (targetIMethod == null || targetCompilationUnit == null) {
            return;
        }
        this.fTargetMethodDeclaration = this.getMethodDeclarationFromIMethod(targetIMethod, targetCompilationUnit);
        this.fTargetIMethodBinding = this.fTargetMethodDeclaration.resolveBinding();
    }

    private static CompilationUnit convertICompilationUnitToCompilationUnit(ICompilationUnit compilationUnit) {
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    private MethodDeclaration getMethodDeclarationFromIMethod(IMethod iMethod, CompilationUnit compilationUnit) throws JavaModelException {
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnit);
    }

    public static enum SelectionInputType {
        IMETHOD,
        TEXT_SELECTION;

    }
}

