/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.makestatic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.FinalConditionsChecker;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.InstanceUsageRewriter;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.MethodReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ChangeCalculator {
    private MethodDeclaration fTargetMethodDeclaration;
    private IMethod fTargetMethod;
    private TextEditBasedChangeManager fChangeManager;
    private AST fTargetMethodDeclarationAST;
    private ASTRewrite fTargetMethodDeclarationASTRewrite;
    private String fParameterName;
    private InstanceUsageRewriter fInstanceUsageRewriter;
    private FinalConditionsChecker fFinalConditionsChecker;

    public ChangeCalculator(MethodDeclaration targetMethodDeclaration, IMethod targetMethod, FinalConditionsChecker finalConditionsChecker) {
        this.fTargetMethodDeclaration = targetMethodDeclaration;
        this.fTargetMethod = targetMethod;
        this.fTargetMethodDeclarationAST = this.fTargetMethodDeclaration.getAST();
        this.fTargetMethodDeclarationASTRewrite = ASTRewrite.create((AST)this.fTargetMethodDeclarationAST);
        this.fParameterName = this.generateUniqueParameterName();
        this.fChangeManager = new TextEditBasedChangeManager();
        this.fFinalConditionsChecker = finalConditionsChecker;
    }

    public TextEditBasedChange[] getOrComputeChanges() throws JavaModelException {
        if (this.fChangeManager.getAllChanges().length != 0) {
            return this.fChangeManager.getAllChanges();
        }
        this.modifyMethodDeclaration();
        return this.fChangeManager.getAllChanges();
    }

    private void computeMethodDeclarationEdit() throws JavaModelException {
        TextEdit methodDeclarationEdit = this.fTargetMethodDeclarationASTRewrite.rewriteAST();
        this.addEditsToChangeManager(List.of(methodDeclarationEdit), this.fTargetMethod.getCompilationUnit());
    }

    private void rewriteInstanceUsages() throws JavaModelException {
        this.fInstanceUsageRewriter = new InstanceUsageRewriter(this.fParameterName, this.fTargetMethodDeclarationASTRewrite, this.fTargetMethodDeclarationAST, this.fTargetMethodDeclaration, this.fFinalConditionsChecker);
        this.fTargetMethodDeclaration.getBody().accept((ASTVisitor)this.fInstanceUsageRewriter);
        this.fFinalConditionsChecker.checkMethodWouldHideParentMethod(this.fInstanceUsageRewriter.getTargetMethodhasInstanceUsage(), this.fTargetMethod);
        this.fFinalConditionsChecker.checkMethodIsNotDuplicate(this.fTargetMethodDeclaration, this.fTargetMethod);
    }

    public void modifyMethodDeclaration() throws JavaModelException {
        this.addStaticModifierToTargetMethod();
        this.rewriteInstanceUsages();
        if (this.fInstanceUsageRewriter.getTargetMethodhasInstanceUsage()) {
            this.addInstanceAsParameterIfUsed();
        }
        this.updateTargetMethodTypeParamList();
        this.deleteOverrideAnnotation();
        this.computeMethodDeclarationEdit();
    }

    private void addStaticModifierToTargetMethod() {
        ModifierRewrite modRewrite = ModifierRewrite.create(this.fTargetMethodDeclarationASTRewrite, (ASTNode)this.fTargetMethodDeclaration);
        modRewrite.setModifiers(this.fTargetMethodDeclaration.getModifiers() | 8, null);
    }

    private String generateUniqueParameterName() {
        String className = ((TypeDeclaration)this.fTargetMethodDeclaration.getParent()).getName().toString();
        List parameters = this.fTargetMethodDeclaration.parameters();
        String baseParameterName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
        int duplicateCount = 1;
        String uniqueParameterName = baseParameterName;
        while (this.parameterNameExists(uniqueParameterName, parameters)) {
            uniqueParameterName = baseParameterName + ++duplicateCount;
        }
        return uniqueParameterName;
    }

    private boolean parameterNameExists(String parameterName, List<SingleVariableDeclaration> parameters) {
        for (SingleVariableDeclaration param : parameters) {
            if (!param.getName().getIdentifier().equals(parameterName)) continue;
            return true;
        }
        return false;
    }

    private void addInstanceAsParameterIfUsed() throws JavaModelException {
        ListRewrite lrw = this.fTargetMethodDeclarationASTRewrite.getListRewrite((ASTNode)this.fTargetMethodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY);
        lrw.insertFirst((ASTNode)this.generateNewParameter(), null);
        this.addParameterToJavaDoc();
    }

    private void addParameterToJavaDoc() {
        Javadoc javadoc = this.fTargetMethodDeclaration.getJavadoc();
        if (javadoc != null) {
            TagElement newParameterTag = this.fTargetMethodDeclarationAST.newTagElement();
            newParameterTag.setTagName("@param");
            newParameterTag.fragments().add(this.fTargetMethodDeclarationAST.newSimpleName(this.fParameterName));
            ListRewrite tagsRewrite = this.fTargetMethodDeclarationASTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            TagElement previousTag = JavadocUtil.findTagElementToInsertAfter(javadoc.tags(), "@param");
            if (previousTag == null) {
                tagsRewrite.insertFirst((ASTNode)newParameterTag, null);
            } else {
                tagsRewrite.insertAfter((ASTNode)newParameterTag, (ASTNode)previousTag, null);
            }
        }
    }

    private SingleVariableDeclaration generateNewParameter() throws JavaModelException {
        String className = ((TypeDeclaration)this.fTargetMethodDeclaration.getParent()).getName().toString();
        IType parentType = this.fTargetMethod.getDeclaringType();
        ITypeParameter[] classTypeParameters = parentType.getTypeParameters();
        SingleVariableDeclaration newParam = this.fTargetMethodDeclarationAST.newSingleVariableDeclaration();
        if (classTypeParameters.length != 0) {
            SimpleType simpleType = this.fTargetMethodDeclarationAST.newSimpleType(this.fTargetMethodDeclarationAST.newName(className));
            ParameterizedType parameterizedType = this.fTargetMethodDeclarationAST.newParameterizedType((Type)simpleType);
            int parameterNumber = 0;
            while (parameterNumber < classTypeParameters.length) {
                SimpleType typeParameter = this.fTargetMethodDeclarationAST.newSimpleType((Name)this.fTargetMethodDeclarationAST.newSimpleName(classTypeParameters[parameterNumber].getElementName()));
                parameterizedType.typeArguments().add(typeParameter);
                ++parameterNumber;
            }
            newParam.setType((Type)parameterizedType);
        } else {
            newParam.setType((Type)this.fTargetMethodDeclarationAST.newSimpleType(this.fTargetMethodDeclarationAST.newName(className)));
        }
        newParam.setName(this.fTargetMethodDeclarationAST.newSimpleName(this.fParameterName));
        return newParam;
    }

    private void updateTargetMethodTypeParamList() throws JavaModelException {
        IType parentType = this.fTargetMethod.getDeclaringType();
        ITypeParameter[] classTypeParameters = parentType.getTypeParameters();
        ListRewrite typeParamsRewrite = this.fTargetMethodDeclarationASTRewrite.getListRewrite((ASTNode)this.fTargetMethodDeclaration, MethodDeclaration.TYPE_PARAMETERS_PROPERTY);
        List<String> methodParameterTypes = this.getMethodParameterTypes();
        List<String> methodTypeParametersNames = this.getTypeParameterNames();
        if (classTypeParameters.length != 0) {
            int i = 0;
            while (i < classTypeParameters.length) {
                boolean paramIsNeeded;
                TypeParameter typeParameter = this.generateTypeParameter(classTypeParameters, i);
                if (this.fFinalConditionsChecker.getStatus().hasError()) {
                    return;
                }
                String typeParamName = typeParameter.getName().getIdentifier();
                String typeParamNameAsArray = typeParamName + "[]";
                boolean bl = paramIsNeeded = methodParameterTypes.contains(typeParamName) || methodParameterTypes.contains(typeParamNameAsArray);
                if ((this.fInstanceUsageRewriter.getTargetMethodhasInstanceUsage() || paramIsNeeded) && !methodTypeParametersNames.contains(typeParameter.getName().getIdentifier())) {
                    typeParamsRewrite.insertLast((ASTNode)typeParameter, null);
                    this.addTypeParamToJavaDoc(typeParameter);
                }
                ++i;
            }
        }
    }

    private TypeParameter generateTypeParameter(ITypeParameter[] classTypeParameters, int i) throws JavaModelException {
        String[] bounds = classTypeParameters[i].getBounds();
        TypeParameter typeParameter = this.fTargetMethodDeclarationAST.newTypeParameter();
        typeParameter.setName(this.fTargetMethodDeclarationAST.newSimpleName(classTypeParameters[i].getElementName()));
        String[] stringArray = bounds;
        int n = bounds.length;
        int n2 = 0;
        while (n2 < n) {
            String bound = stringArray[n2];
            this.fFinalConditionsChecker.checkBoundNotContainingWildCardType(bound);
            if (!this.fFinalConditionsChecker.getStatus().hasError()) {
                SimpleType boundType = this.fTargetMethodDeclarationAST.newSimpleType((Name)this.fTargetMethodDeclarationAST.newSimpleName(bound));
                typeParameter.typeBounds().add(boundType);
            }
            ++n2;
        }
        return typeParameter;
    }

    private List<String> getMethodParameterTypes() {
        List methodParams = this.fTargetMethodDeclaration.parameters();
        ArrayList<String> methodParameterTypes = new ArrayList<String>(methodParams.size());
        for (SingleVariableDeclaration methodParam : methodParams) {
            Type type = methodParam.getType();
            if (type.isParameterizedType()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                List typeParamsOfMethodParam = parameterizedType.typeArguments();
                for (Type typeParamOfMethodParam : typeParamsOfMethodParam) {
                    methodParameterTypes.add(typeParamOfMethodParam.resolveBinding().getName());
                }
            }
            String typeName = type.toString();
            methodParameterTypes.add(typeName);
        }
        return methodParameterTypes;
    }

    private List<String> getTypeParameterNames() {
        List methodTypeParameters = this.fTargetMethodDeclaration.typeParameters();
        ArrayList<String> methodTypeParametersNames = new ArrayList<String>(methodTypeParameters.size());
        for (TypeParameter methodTypeParam : methodTypeParameters) {
            methodTypeParametersNames.add(methodTypeParam.getName().getIdentifier());
        }
        return methodTypeParametersNames;
    }

    private void addTypeParamToJavaDoc(TypeParameter typeParameter) {
        Javadoc javadoc = this.fTargetMethodDeclaration.getJavadoc();
        if (javadoc != null) {
            TextElement textElement = this.fTargetMethodDeclarationAST.newTextElement();
            textElement.setText("<" + typeParameter.getName().getIdentifier() + ">");
            TagElement newParameterTag = this.fTargetMethodDeclarationAST.newTagElement();
            newParameterTag.setTagName("@param");
            newParameterTag.fragments().add(textElement);
            TagElement subsequentTag = JavadocUtil.findTagElementToInsertBefore(javadoc.tags(), "@param");
            ListRewrite tagsRewrite = this.fTargetMethodDeclarationASTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            if (subsequentTag == null) {
                tagsRewrite.insertLast((ASTNode)newParameterTag, null);
            } else {
                tagsRewrite.insertBefore((ASTNode)newParameterTag, (ASTNode)subsequentTag, null);
            }
        }
    }

    private void deleteOverrideAnnotation() {
        ListRewrite listRewrite = this.fTargetMethodDeclarationASTRewrite.getListRewrite((ASTNode)this.fTargetMethodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY);
        for (Object obj : this.fTargetMethodDeclaration.modifiers()) {
            MarkerAnnotation markerAnnotation;
            if (!(obj instanceof MarkerAnnotation) || !(markerAnnotation = (MarkerAnnotation)obj).getTypeName().getFullyQualifiedName().equals("Override")) continue;
            listRewrite.remove((ASTNode)markerAnnotation, null);
        }
    }

    private void addEditsToChangeManager(List<TextEdit> editsToAdd, ICompilationUnit iCompilationUnit) {
        CompilationUnitChange compilationUnitChange = (CompilationUnitChange)this.fChangeManager.get(iCompilationUnit);
        MultiTextEdit allTextEdits = (MultiTextEdit)compilationUnitChange.getEdit();
        if (allTextEdits == null) {
            allTextEdits = new MultiTextEdit();
        }
        for (TextEdit editToAdd : editsToAdd) {
            allTextEdits.addChild(editToAdd);
        }
        String changeName = Messages.format(RefactoringCoreMessages.MakeStaticRefactoring_change_name, iCompilationUnit.getElementName());
        CompilationUnitChange newCompilationUnitChange = new CompilationUnitChange(changeName, iCompilationUnit);
        newCompilationUnitChange.setEdit((TextEdit)allTextEdits);
        this.fChangeManager.manage(iCompilationUnit, (TextEditBasedChange)newCompilationUnitChange);
    }

    public void handleMethodInvocations(IProgressMonitor progressMonitor, IMethodBinding targetMethodBinding) throws CoreException {
        ICompilationUnit[] affectedICompilationUnits;
        TargetProvider targetProvider = TargetProvider.create(this.fTargetMethodDeclaration);
        targetProvider.initialize();
        IProgressMonitor sliceProgessMonitor = progressMonitor.slice(1);
        ICompilationUnit[] iCompilationUnitArray = affectedICompilationUnits = targetProvider.getAffectedCompilationUnits(this.fFinalConditionsChecker.getStatus(), new ReferencesInBinaryContext(""), sliceProgessMonitor);
        int n = affectedICompilationUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit affectedICompilationUnit = iCompilationUnitArray[n2];
            CompilationUnit affectedCompilationUnit = this.convertICUtoCU(affectedICompilationUnit);
            affectedCompilationUnit.accept((ASTVisitor)new MethodReferenceFinder(targetMethodBinding, this.fFinalConditionsChecker));
            if (this.fFinalConditionsChecker.getStatus().hasFatalError()) {
                return;
            }
            BodyDeclaration[] bodies = targetProvider.getAffectedBodyDeclarations(affectedICompilationUnit, null);
            ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
            BodyDeclaration[] bodyDeclarationArray = bodies;
            int n3 = bodies.length;
            int n4 = 0;
            while (n4 < n3) {
                ASTNode[] invocations;
                BodyDeclaration body = bodyDeclarationArray[n4];
                ASTNode[] aSTNodeArray = invocations = targetProvider.getInvocations(body, null);
                int n5 = invocations.length;
                int n6 = 0;
                while (n6 < n5) {
                    ASTNode invocationASTNode = aSTNodeArray[n6];
                    MethodInvocation invocation = (MethodInvocation)invocationASTNode;
                    textEdits.add(this.createMethodInvocationChange(invocation));
                    ++n6;
                }
                ++n4;
            }
            if (this.fFinalConditionsChecker.getStatus().hasFatalError()) {
                return;
            }
            this.addEditsToChangeManager(textEdits, affectedICompilationUnit);
            ++n2;
        }
    }

    private CompilationUnit convertICUtoCU(ICompilationUnit compilationUnit) {
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    private TextEdit createMethodInvocationChange(MethodInvocation invocation) throws JavaModelException {
        AST ast = invocation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.fInstanceUsageRewriter.getTargetMethodhasInstanceUsage()) {
            ASTNode parent;
            boolean isMember;
            Object newArg = invocation.getExpression() != null ? ASTNode.copySubtree((AST)ast, (ASTNode)invocation.getExpression()) : ((isMember = this.isMember(parent = this.findParentClass(invocation))) ? this.qualifyThisExpression(invocation, ast) : ast.newThisExpression());
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)invocation, MethodInvocation.ARGUMENTS_PROPERTY);
            listRewrite.insertFirst(newArg, null);
        }
        SimpleName optionalExpression = ast.newSimpleName(((TypeDeclaration)this.fTargetMethodDeclaration.getParent()).getName().getIdentifier());
        rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)optionalExpression, null);
        TextEdit methodInvocationEdit = rewrite.rewriteAST();
        return methodInvocationEdit;
    }

    private ASTNode qualifyThisExpression(MethodInvocation invocation, AST ast) {
        ThisExpression thisExpression = ast.newThisExpression();
        IMethodBinding invocationBinding = invocation.resolveMethodBinding();
        ITypeBinding outerClassBinding = invocationBinding.getDeclaringClass();
        String outerClassName = outerClassBinding.getName();
        thisExpression.setQualifier((Name)ast.newSimpleName(outerClassName));
        ThisExpression newArg = thisExpression;
        return newArg;
    }

    private boolean isMember(ASTNode parent) {
        boolean isMember = false;
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration currentClass = (AbstractTypeDeclaration)parent;
            if (currentClass.isMemberTypeDeclaration()) {
                isMember = true;
            }
        } else if (parent instanceof AnonymousClassDeclaration) {
            isMember = true;
        }
        return isMember;
    }

    private ASTNode findParentClass(MethodInvocation invocation) {
        MethodInvocation parent = invocation;
        while (!(parent instanceof AbstractTypeDeclaration) && !(parent instanceof AnonymousClassDeclaration)) {
            parent = parent.getParent();
        }
        return parent;
    }
}

