/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class VariableDeclarationFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static VariableDeclarationFixCore createChangeModifierToFinalFix(CompilationUnit compilationUnit, ASTNode[] selectedNodes) {
        HashMap<IBinding, List<SimpleName>> writtenNames = new HashMap<IBinding, List<SimpleName>>();
        HashSet<String> unresolved = new HashSet<String>();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames, unresolved);
        try {
            compilationUnit.accept((ASTVisitor)finder);
        }
        catch (AbortSearchException e) {
            return null;
        }
        ArrayList<ModifierChangeOperation> ops = new ArrayList<ModifierChangeOperation>();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(true, true, true, ops, writtenNames, unresolved);
        if (selectedNodes.length == 1) {
            selectedNodes[0].accept((ASTVisitor)visitor);
        } else {
            ASTNode[] aSTNodeArray = selectedNodes;
            int n = selectedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode selectedNode = aSTNodeArray[n2];
                selectedNode.accept((ASTVisitor)visitor);
                ++n2;
            }
        }
        if (ops.size() == 0) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] result = ops.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[ops.size()]);
        String label = result.length == 1 ? FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description : FixMessages.VariableDeclarationFix_ChangeMidifiersToFinalWherPossible_description;
        return new VariableDeclarationFixCore(label, compilationUnit, result);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals) {
        if (!(addFinalFields || addFinalParameters || addFinalLocals)) {
            return null;
        }
        HashMap<IBinding, List<SimpleName>> writtenNames = new HashMap<IBinding, List<SimpleName>>();
        HashSet<String> unresolved = new HashSet<String>();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames, unresolved);
        try {
            compilationUnit.accept((ASTVisitor)finder);
        }
        catch (AbortSearchException e) {
            return null;
        }
        ArrayList<ModifierChangeOperation> operations = new ArrayList<ModifierChangeOperation>();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(addFinalFields, addFinalParameters, addFinalLocals, operations, writtenNames, unresolved);
        compilationUnit.accept((ASTVisitor)visitor);
        if (operations.isEmpty()) {
            return null;
        }
        return new VariableDeclarationFixCore(FixMessages.VariableDeclarationFix_add_final_change_name, compilationUnit, operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]));
    }

    private static ModifierChangeOperation createAddFinalOperation(SimpleName name, ASTNode decl) {
        if (decl == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (!VariableDeclarationFixCore.canAddFinal(binding, decl)) {
            return null;
        }
        if (decl instanceof SingleVariableDeclaration || decl instanceof VariableDeclarationExpression) {
            return new ModifierChangeOperation(decl, new ArrayList<VariableDeclarationFragment>(), 16, 0);
        }
        if (decl instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)decl;
            if ((decl = decl.getParent()) instanceof FieldDeclaration || decl instanceof VariableDeclarationStatement) {
                ArrayList<VariableDeclarationFragment> list = new ArrayList<VariableDeclarationFragment>();
                list.add(frag);
                return new ModifierChangeOperation(decl, list, 16, 0);
            }
            if (decl instanceof VariableDeclarationExpression) {
                return new ModifierChangeOperation(decl, new ArrayList<VariableDeclarationFragment>(), 16, 0);
            }
        }
        return null;
    }

    public static boolean canAddFinal(IBinding binding, ASTNode declNode) {
        MethodDeclaration declaration;
        ASTNode varDecl;
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varbinding = (IVariableBinding)binding;
        int modifiers = varbinding.getModifiers();
        if (Modifier.isFinal((int)modifiers) || Modifier.isVolatile((int)modifiers) || Modifier.isTransient((int)modifiers)) {
            return false;
        }
        VariableDeclarationExpression parent = ASTNodes.getParent(declNode, VariableDeclarationExpression.class);
        if (parent != null && parent.fragments().size() > 1) {
            return false;
        }
        if (varbinding.isField() && !Modifier.isPrivate((int)modifiers)) {
            return false;
        }
        if (varbinding.isRecordComponent()) {
            return false;
        }
        return !varbinding.isParameter() || !((varDecl = declNode.getParent()) instanceof MethodDeclaration) || (declaration = (MethodDeclaration)varDecl).getBody() != null;
    }

    protected VariableDeclarationFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class ModifierChangeOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ASTNode fDeclaration;
        private final List<VariableDeclarationFragment> fToChange;
        private final int fIncludedModifiers;
        private final int fExcludedModifiers;

        public ModifierChangeOperation(ASTNode declaration, List<VariableDeclarationFragment> toChange, int includedModifiers, int excludedModifiers) {
            this.fDeclaration = declaration;
            this.fToChange = toChange;
            this.fIncludedModifiers = includedModifiers;
            this.fExcludedModifiers = excludedModifiers;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description, cuRewrite);
            if (this.fDeclaration instanceof VariableDeclarationStatement) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationStatement)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof FieldDeclaration) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((FieldDeclaration)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof SingleVariableDeclaration) {
                VariableDeclarationRewrite.rewriteModifiers((SingleVariableDeclaration)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof VariableDeclarationExpression) {
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationExpression)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            }
        }
    }

    public static class ReturnFinder
    extends ASTVisitor {
        boolean foundOne;

        public boolean visit(ReturnStatement node) {
            this.foundOne = true;
            return super.visit(node);
        }
    }

    public static class VariableDeclarationFinder
    extends GenericVisitor {
        private final List<ModifierChangeOperation> fResult;
        private final HashMap<IBinding, List<SimpleName>> fWrittenVariables;
        private final HashSet<String> fUnresolved;
        private final boolean fAddFinalFields;
        private final boolean fAddFinalParameters;
        private final boolean fAddFinalLocals;

        public VariableDeclarationFinder(boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals, List<ModifierChangeOperation> result, HashMap<IBinding, List<SimpleName>> writtenNames, HashSet<String> unresolved) {
            this.fAddFinalFields = addFinalFields;
            this.fAddFinalParameters = addFinalParameters;
            this.fAddFinalLocals = addFinalLocals;
            this.fResult = result;
            this.fWrittenVariables = writtenNames;
            this.fUnresolved = unresolved;
        }

        @Override
        public boolean visit(FieldDeclaration node) {
            if (this.fAddFinalFields) {
                this.handleFragments(node.fragments(), (ASTNode)node);
            }
            List fragments = node.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                Expression initializer = fragment.getInitializer();
                if (initializer == null) continue;
                initializer.accept((ASTVisitor)this);
            }
            return false;
        }

        @Override
        public boolean visit(VariableDeclarationStatement node) {
            if (this.fAddFinalLocals) {
                this.handleFragments(node.fragments(), (ASTNode)node);
            }
            List fragments = node.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                Expression initializer = fragment.getInitializer();
                if (initializer == null) continue;
                initializer.accept((ASTVisitor)this);
            }
            return false;
        }

        @Override
        public boolean visit(VariableDeclarationExpression node) {
            if (this.fAddFinalLocals && node.fragments().size() == 1) {
                SimpleName name = ((VariableDeclarationFragment)node.fragments().get(0)).getName();
                IBinding binding = name.resolveBinding();
                if (binding == null) {
                    return false;
                }
                if (this.fWrittenVariables.containsKey(binding)) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFixCore.createAddFinalOperation(name, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }

        private boolean handleFragments(List<VariableDeclarationFragment> list, ASTNode declaration) {
            ArrayList<VariableDeclarationFragment> toChange = new ArrayList<VariableDeclarationFragment>();
            for (VariableDeclarationFragment fragment : list) {
                SimpleName name = fragment.getName();
                IBinding resolveBinding = name.resolveBinding();
                if (!VariableDeclarationFixCore.canAddFinal(resolveBinding, declaration)) continue;
                IVariableBinding varbinding = (IVariableBinding)resolveBinding;
                if (varbinding.isField()) {
                    if (!this.fieldCanBeFinal(fragment, varbinding)) continue;
                    toChange.add(fragment);
                    continue;
                }
                if (this.fWrittenVariables.containsKey(resolveBinding)) continue;
                toChange.add(fragment);
            }
            if (toChange.size() == 0) {
                return false;
            }
            ModifierChangeOperation op = new ModifierChangeOperation(declaration, toChange, 16, 0);
            this.fResult.add(op);
            return false;
        }

        private boolean fieldCanBeFinal(VariableDeclarationFragment fragment, final IVariableBinding binding) {
            class SearchException
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                SearchException() {
                }
            }
            MethodDeclaration constructor3;
            if (Modifier.isStatic((int)((FieldDeclaration)fragment.getParent()).getModifiers())) {
                return false;
            }
            if (!this.fWrittenVariables.containsKey(binding) && !this.fUnresolved.contains(binding.getName())) {
                return fragment.getInitializer() != null;
            }
            if (fragment.getInitializer() != null) {
                return false;
            }
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass == null) {
                return false;
            }
            List<SimpleName> writes = this.fWrittenVariables.get(binding);
            if (!this.isWrittenInTypeConstructors(writes, declaringClass)) {
                return false;
            }
            HashSet<IMethodBinding> writingConstructorBindings = new HashSet<IMethodBinding>();
            ArrayList<MethodDeclaration> writingConstructors = new ArrayList<MethodDeclaration>();
            for (SimpleName name : writes) {
                MethodDeclaration constructor2 = this.getWritingConstructor(name);
                if (writingConstructors.contains(constructor2)) {
                    return false;
                }
                if (this.canReturn(constructor2)) {
                    return false;
                }
                writingConstructors.add(constructor2);
                IMethodBinding constructorBinding = constructor2.resolveBinding();
                if (constructorBinding == null) {
                    return false;
                }
                writingConstructorBindings.add(constructorBinding);
            }
            for (MethodDeclaration constructor3 : writingConstructors) {
                if (!this.callsWritingConstructor(constructor3, writingConstructorBindings)) continue;
                return false;
            }
            constructor3 = (MethodDeclaration)writingConstructors.get(0);
            AbstractTypeDeclaration typeDecl = ASTNodes.getParent((ASTNode)constructor3, AbstractTypeDeclaration.class);
            if (typeDecl == null) {
                return false;
            }
            List bodyDeclarations = typeDecl.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                MethodDeclaration method;
                if (!(bodyDeclaration instanceof MethodDeclaration) || !(method = (MethodDeclaration)bodyDeclaration).isConstructor()) continue;
                IMethodBinding methodBinding = method.resolveBinding();
                if (methodBinding == null) {
                    return false;
                }
                if (writingConstructorBindings.contains(methodBinding) || this.callsWritingConstructor(method, writingConstructorBindings)) continue;
                return false;
            }
            ASTVisitor findFieldLambdasUsingBinding = new ASTVisitor(){

                public boolean visit(FieldDeclaration node) {
                    ASTVisitor findLambdas = new ASTVisitor(){

                        public boolean visit(LambdaExpression lambda) {
                            ASTVisitor findFieldRef = new ASTVisitor(){

                                public boolean visit(SimpleName name) {
                                    IVariableBinding varBinding;
                                    IBinding nameBinding = name.resolveBinding();
                                    if (nameBinding == null || nameBinding instanceof IVariableBinding && (varBinding = (IVariableBinding)nameBinding).isEqualTo((IBinding)binding)) {
                                        throw new SearchException();
                                    }
                                    return false;
                                }
                            };
                            lambda.accept(findFieldRef);
                            return true;
                        }
                    };
                    node.accept(findLambdas);
                    return true;
                }
            };
            try {
                typeDecl.accept(findFieldLambdasUsingBinding);
            }
            catch (SearchException e) {
                return false;
            }
            return true;
        }

        private boolean canReturn(MethodDeclaration constructor) {
            ReturnFinder retFinder = new ReturnFinder();
            constructor.accept((ASTVisitor)retFinder);
            return retFinder.foundOne;
        }

        private boolean callsWritingConstructor(MethodDeclaration methodDeclaration, HashSet<IMethodBinding> writingConstructorBindings) {
            HashSet<MethodDeclaration> visitedMethodDeclarations = new HashSet<MethodDeclaration>();
            visitedMethodDeclarations.add(methodDeclaration);
            return this.callsWritingConstructor(methodDeclaration, writingConstructorBindings, visitedMethodDeclarations);
        }

        private boolean callsWritingConstructor(MethodDeclaration methodDeclaration, HashSet<IMethodBinding> writingConstructorBindings, Set<MethodDeclaration> visitedMethodDeclarations) {
            Block body = methodDeclaration.getBody();
            if (body == null) {
                return false;
            }
            List statements = body.statements();
            if (statements.size() == 0) {
                return false;
            }
            Statement statement = (Statement)statements.get(0);
            if (!(statement instanceof ConstructorInvocation)) {
                return false;
            }
            ConstructorInvocation invocation = (ConstructorInvocation)statement;
            IMethodBinding constructorBinding = invocation.resolveConstructorBinding();
            if (constructorBinding == null) {
                return false;
            }
            if (writingConstructorBindings.contains(constructorBinding)) {
                return true;
            }
            ASTNode declaration = ASTNodes.findDeclaration((IBinding)constructorBinding, methodDeclaration.getParent());
            if (!(declaration instanceof MethodDeclaration)) {
                return false;
            }
            if (visitedMethodDeclarations.contains(declaration)) {
                return false;
            }
            visitedMethodDeclarations.add(methodDeclaration);
            return this.callsWritingConstructor((MethodDeclaration)declaration, writingConstructorBindings, visitedMethodDeclarations);
        }

        private boolean isWrittenInTypeConstructors(List<SimpleName> writes, ITypeBinding declaringClass) {
            for (final SimpleName name : writes) {
                MethodDeclaration methodDeclaration = this.getWritingConstructor(name);
                if (methodDeclaration == null) {
                    return false;
                }
                if (!methodDeclaration.isConstructor()) {
                    return false;
                }
                IMethodBinding constructor = methodDeclaration.resolveBinding();
                if (constructor == null) {
                    return false;
                }
                ITypeBinding declaringClass2 = constructor.getDeclaringClass();
                if (!declaringClass.equals((Object)declaringClass2)) {
                    return false;
                }
                final IBinding writtenBinding = name.resolveBinding();
                if (writtenBinding == null) {
                    return false;
                }
                ASTVisitor visitor = new ASTVisitor(){

                    public boolean visit(SimpleName node) {
                        IBinding nodeBinding = node.resolveBinding();
                        if (nodeBinding == null) {
                            throw new AbortSearchException();
                        }
                        if (nodeBinding.isEqualTo(writtenBinding) && node.getStartPosition() < name.getStartPosition()) {
                            throw new AbortSearchException();
                        }
                        return false;
                    }
                };
                try {
                    methodDeclaration.accept(visitor);
                }
                catch (AbortSearchException e) {
                    return false;
                }
            }
            return true;
        }

        private MethodDeclaration getWritingConstructor(SimpleName name) {
            Assignment assignement = ASTNodes.getParent((ASTNode)name, Assignment.class);
            if (assignement == null) {
                return null;
            }
            ASTNode expression = assignement.getParent();
            if (!(expression instanceof ExpressionStatement)) {
                return null;
            }
            ASTNode block = expression.getParent();
            if (!(block instanceof Block)) {
                return null;
            }
            ASTNode methodDeclaration = block.getParent();
            if (!(methodDeclaration instanceof MethodDeclaration)) {
                return null;
            }
            return (MethodDeclaration)methodDeclaration;
        }

        @Override
        public boolean visit(VariableDeclarationFragment node) {
            SimpleName name = node.getName();
            IBinding binding = name.resolveBinding();
            if (binding == null) {
                return true;
            }
            if (this.fWrittenVariables.containsKey(binding)) {
                return true;
            }
            ModifierChangeOperation op = VariableDeclarationFixCore.createAddFinalOperation(name, (ASTNode)node);
            if (op == null) {
                return true;
            }
            this.fResult.add(op);
            return true;
        }

        @Override
        public boolean visit(SingleVariableDeclaration node) {
            SimpleName name = node.getName();
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            IVariableBinding varBinding = (IVariableBinding)binding;
            if (this.fWrittenVariables.containsKey(varBinding)) {
                return false;
            }
            if (this.fAddFinalParameters && this.fAddFinalLocals) {
                ModifierChangeOperation op = VariableDeclarationFixCore.createAddFinalOperation(name, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalParameters) {
                if (!varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFixCore.createAddFinalOperation(name, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalLocals) {
                if (varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFixCore.createAddFinalOperation(name, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }
    }

    public static class WrittenNamesFinder
    extends GenericVisitor {
        private final HashMap<IBinding, List<SimpleName>> fResult;
        private final HashSet<String> fUnresolved;

        public WrittenNamesFinder(HashMap<IBinding, List<SimpleName>> result, HashSet<String> unresolved) {
            this.fResult = result;
            this.fUnresolved = unresolved;
        }

        @Override
        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof VariableDeclarationFragment) {
                return super.visit(node);
            }
            if (node.getParent() instanceof SingleVariableDeclaration) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (binding == null) {
                this.fUnresolved.add(node.getFullyQualifiedName());
            } else if (binding.isRecovered()) {
                throw new AbortSearchException();
            }
            if (!(binding instanceof IVariableBinding)) {
                return super.visit(node);
            }
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            if (ASTResolving.isWriteAccess((Name)node)) {
                List<SimpleName> list = this.fResult.containsKey(binding) ? this.fResult.get(binding) : new ArrayList<SimpleName>();
                list.add(node);
                this.fResult.put(binding, list);
            }
            return super.visit(node);
        }
    }
}

