/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.index.IIndexDocument;
import org.eclipse.rcptt.core.model.index.IIndexer;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.jobs.IJob;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexManager;
import org.eclipse.rcptt.internal.core.model.index.IndexerManager;
import org.eclipse.rcptt.internal.core.model.index.NamedElementRemoveRequest;
import org.eclipse.rcptt.internal.core.model.index.NamedElementRequest;
import org.eclipse.rcptt.internal.core.model.index.NamedElementsRequest;
import org.eclipse.rcptt.internal.core.model.index.ProjectRequest;
import org.eclipse.rcptt.internal.core.model.index.RemoveIndexRequest;

public class Q7ProjectIndexer
implements IProjectIndexer,
IProjectIndexer.Internal {
    private final IndexManager manager = ModelManager.getModelManager().getIndexManager();
    private Set<IQ7NamedElement> indexingSet = new HashSet<IQ7NamedElement>();

    @Override
    public void request(IJob job) {
        this.manager.request(job);
    }

    @Override
    public void requestIfNotWaiting(IJob job) {
        this.manager.requestIfNotWaiting(job);
    }

    @Override
    public IndexManager getIndexManager() {
        return this.manager;
    }

    @Override
    public void indexProject(IQ7Project project) {
        ProjectRequest request = new ProjectRequest(this, project);
        this.requestIfNotWaiting(request);
    }

    public void indexNamedElement(IQ7NamedElement element) {
        this.request(new NamedElementRequest(this, element));
    }

    public void indexNamedElements(Collection<IQ7NamedElement> toIndex) {
        if (toIndex.size() < 10) {
            for (IQ7NamedElement e : toIndex) {
                this.indexNamedElement(e);
            }
            return;
        }
        HashMap<IQ7Project, ArrayList<IQ7NamedElement>> prjs = new HashMap<IQ7Project, ArrayList<IQ7NamedElement>>();
        for (IQ7NamedElement iQ7NamedElement : toIndex) {
            IQ7Project project = iQ7NamedElement.getQ7Project();
            ArrayList<IQ7NamedElement> list = (ArrayList<IQ7NamedElement>)prjs.get(project);
            if (list == null) {
                list = new ArrayList<IQ7NamedElement>();
                prjs.put(project, list);
            }
            list.add(iQ7NamedElement);
        }
        for (Map.Entry entry : prjs.entrySet()) {
            this.request(new NamedElementsRequest(this, (IQ7Project)entry.getKey(), (List)entry.getValue(), false));
        }
    }

    @Override
    public void removeNamedElement(IQ7Project project, String path) {
        this.request(new NamedElementRemoveRequest(this, project, path));
    }

    @Override
    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, projectPath));
    }

    @Override
    public boolean wantRefreshOnStart() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void indexNamedElement(Index index, IQ7NamedElement element) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [51[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void doIndexing(IIndexDocument document) {
        try {
            IIndexer[] indexers;
            int n;
            String[] stringArray;
            String[] verifications;
            String ctx;
            int n2;
            String[] contexts;
            Object type;
            NamedElement namedElement;
            String tags;
            IQ7NamedElement element = document.getElement();
            document.addKey("id", element.getID());
            document.addKey("name", element.getElementName());
            if (element instanceof ITestCase) {
                try {
                    document.addKey("is_empty", Boolean.toString(Scenarios.isEmpty((Scenario)element.getNamedElement())));
                }
                catch (Throwable e) {
                    RcpttPlugin.log(e);
                }
            }
            if ((tags = element.getTags()) != null && tags.length() > 0) {
                List<String> list = TagsUtil.extractTags(tags);
                for (String tag : list) {
                    document.addKey("tags", tag);
                }
            }
            if (element instanceof IVerification) {
                namedElement = element.getNamedElement();
                type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)namedElement);
                if (type != null) {
                    document.addKey("verification_type", type.getId());
                }
            } else if (element instanceof IContext) {
                namedElement = element.getNamedElement();
                type = ContextTypeManager.getInstance().getTypeByContext((Context)namedElement);
                if (type != null) {
                    document.addKey("context_type", ((ContextType)type).getId());
                }
            } else if (element instanceof ITestCase) {
                ITestCase testcase = (ITestCase)element;
                String[] stringArray2 = contexts = testcase.getContexts();
                n2 = contexts.length;
                int n3 = 0;
                while (n3 < n2) {
                    ctx = stringArray2[n3];
                    document.addKey("ctx_ref", ctx);
                    ++n3;
                }
                stringArray = verifications = testcase.getVerifications();
                n = verifications.length;
                n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    document.addKey("verification_ref", v);
                    ++n2;
                }
                String reference = testcase.getExternalReference();
                if (reference != null) {
                    document.addKey("extern_ref", reference);
                }
            } else if (element instanceof IQ7ProjectMetadata) {
                IQ7ProjectMetadata meta = (IQ7ProjectMetadata)element;
                String[] stringArray3 = contexts = meta.getContexts();
                n2 = contexts.length;
                int reference = 0;
                while (reference < n2) {
                    ctx = stringArray3[reference];
                    document.addKey("ctx_ref", ctx);
                    ++reference;
                }
                stringArray = verifications = meta.getVerifications();
                n = verifications.length;
                n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    document.addKey("verification_ref", v);
                    ++n2;
                }
            }
            IIndexer[] iIndexerArray = indexers = IndexerManager.getInstance().getIndexers();
            int n4 = indexers.length;
            int n5 = 0;
            while (n5 < n4) {
                IIndexer iIndexer = iIndexerArray[n5];
                iIndexer.index(document);
                ++n5;
            }
        }
        catch (Throwable e) {
            Status status = new Status(2, "org.eclipse.rcptt.core", e.getMessage(), e);
            RcpttPlugin.getDefault().getLog().log((IStatus)status);
            document.remove();
        }
    }

    @Override
    public Index getProjectIndex(IQ7Project project) {
        return this.getIndexManager().getIndex(project.getProject().getFullPath());
    }
}

