/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.Arrays;
import java.util.List;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.ReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;

public class UseScanReferenceVisitor
extends UseScanVisitor {
    private final IApiComponent fLookupAPIComponent;
    private List<String> fLookupMemberTypes;
    private String fCurrentReferencedMemberRootType;
    private IComponentDescriptor fCurrentComponent;
    private IComponentDescriptor fReferencingComponent;
    private final IReferenceCollection fReferences;
    private IMemberDescriptor fCurrentReferencedMember;

    public UseScanReferenceVisitor(IApiComponent component, String[] lookupTypes, IReferenceCollection references) {
        this.fLookupAPIComponent = component;
        this.fLookupMemberTypes = lookupTypes == null || lookupTypes.length == 0 ? null : Arrays.asList(lookupTypes);
        this.fReferences = references;
    }

    @Override
    public boolean visitComponent(IComponentDescriptor target) {
        if (this.fLookupAPIComponent == null || this.fLookupAPIComponent.getSymbolicName().equals(target.getId())) {
            this.fCurrentComponent = target;
            return true;
        }
        return false;
    }

    @Override
    public boolean visitMember(IMemberDescriptor referencedMember) {
        String referencedMemberRootType = referencedMember instanceof IReferenceTypeDescriptor ? ((IReferenceTypeDescriptor)referencedMember).getQualifiedName() : referencedMember.getEnclosingType().getQualifiedName();
        if (referencedMemberRootType.indexOf(36) > -1) {
            referencedMemberRootType = referencedMemberRootType.substring(0, referencedMemberRootType.indexOf(36));
        }
        boolean found = this.fLookupMemberTypes == null || this.fLookupMemberTypes.contains(referencedMemberRootType);
        this.fCurrentReferencedMemberRootType = referencedMemberRootType;
        this.fCurrentReferencedMember = referencedMember;
        return found;
    }

    @Override
    public void visitReference(IReferenceDescriptor reference) {
        ReferenceDescriptor refDesc = new ReferenceDescriptor(this.fReferencingComponent, reference.getMember(), reference.getLineNumber(), this.fCurrentComponent, this.fCurrentReferencedMember, reference.getReferenceKind(), reference.getReferenceFlags(), reference.getVisibility(), null);
        this.fReferences.add(this.fCurrentReferencedMemberRootType, refDesc);
    }

    @Override
    public boolean visitReferencingComponent(IComponentDescriptor component) {
        this.fReferencingComponent = component;
        return true;
    }
}

