/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.server.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.rcptt.ecl.server.tcp.EclTcpServer;

public enum EclTcpServerManager {
    Instance;

    private final Map<Integer, EclTcpServer> servers = new HashMap<Integer, EclTcpServer>();

    public EclTcpServer startServer(int port) throws IOException {
        return this.startServer(port, true, false);
    }

    public synchronized EclTcpServer startServer(int port, boolean useJobs, boolean useFixedPool) throws IOException {
        EclTcpServer server = this.servers.get(port);
        if (server == null) {
            EclTcpServer newServer = new EclTcpServer(port, useJobs);
            newServer.start();
            while (newServer.isStarting()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.servers.put(port, newServer);
            return newServer;
        }
        throw new IOException("Another server is already running on port " + port);
    }

    public synchronized void stopServer(int port) throws IOException {
        block4: {
            EclTcpServer server = this.servers.remove(port);
            if (server != null) {
                server.interrupt();
                try {
                    server.join(10000L);
                    if (server.isAlive()) {
                        throw new IOException("Failed to stop " + server);
                    }
                    break block4;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Failed to stop server", e);
                }
            }
            throw new IOException("No server found on port " + port);
        }
    }

    public synchronized EclTcpServer getServer(int port) {
        return this.servers.get(port);
    }

    public synchronized void terminateAll() {
        HashSet<Integer> ports = new HashSet<Integer>(this.servers.keySet());
        IOException result = null;
        for (int i : ports) {
            try {
                this.stopServer(i);
            }
            catch (IOException e) {
                if (result == null) {
                    result = e;
                    continue;
                }
                result.addSuppressed(e);
            }
        }
    }
}

