/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import org.eclipse.rcptt.core.ecl.model.ArgDecl;
import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;

public abstract class Proposal {
    public final Declaration decl;
    public int prefixLength = 0;

    public Proposal(Declaration decl) {
        this.decl = decl;
    }

    public final boolean startsWith(String prefix) {
        return this.fullText().toLowerCase().startsWith(prefix);
    }

    public String insertionString() {
        return this.fullText().substring(this.prefixLength);
    }

    public abstract String fullText();

    public String toString() {
        return this.fullText();
    }

    public static class ArgNameProposal
    extends Proposal {
        public ArgNameProposal(ArgDecl decl) {
            super(decl);
        }

        @Override
        public String fullText() {
            return "-" + this.decl.name;
        }
    }

    public static class ProcNameProposal
    extends Proposal {
        public ProcNameProposal(ProcDecl decl) {
            super(decl);
        }

        @Override
        public String fullText() {
            return this.decl.name;
        }
    }

    public static class VarValueProposal
    extends Proposal {
        public VarValueProposal(VarDecl decl) {
            super(decl);
        }

        @Override
        public String fullText() {
            return "$" + this.decl.name;
        }
    }
}

