/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.util.ManyToMany;

public class GeneratedFileMap
extends ManyToMany<IFile, IFile> {
    private static final int SERIALIZATION_VERSION = 2;
    private final IProject _proj;
    private final Map<IFile, Set<Flags>> _flags = new HashMap<IFile, Set<Flags>>();
    private final boolean _isTestCode;

    public GeneratedFileMap(IProject proj, boolean isTestCode) {
        this._proj = proj;
        this._isTestCode = isTestCode;
        this.readState();
    }

    @Override
    public synchronized boolean clear() {
        this._flags.clear();
        return super.clear();
    }

    @Override
    public synchronized boolean remove(IFile key, IFile value) {
        boolean removed = super.remove(key, value);
        if (removed && !this.containsValue(value)) {
            this._flags.remove(value);
        }
        return removed;
    }

    @Override
    public synchronized boolean removeKey(IFile key) {
        Set values = this.getValues(key);
        boolean removed = super.removeKey(key);
        if (removed) {
            for (IFile value : values) {
                if (this.containsValue(value)) continue;
                this._flags.remove(value);
            }
        }
        return removed;
    }

    @Override
    public synchronized boolean removeValue(IFile value) {
        boolean removed = super.removeValue(value);
        if (removed) {
            this._flags.remove(value);
        }
        return removed;
    }

    public synchronized void clearState() {
        boolean successfullyDeleted;
        this.clear();
        File state = this.getStateFile(this._proj, this._isTestCode);
        if (state != null && !(successfullyDeleted = state.delete()) && state.exists()) {
            AptPlugin.log(new IOException("Could not delete apt dependency state file"), state.getPath());
        }
        this.clearDirtyBit();
    }

    @Override
    public synchronized boolean put(IFile parent, IFile generated) {
        return this.put(parent, generated, Collections.emptySet());
    }

    public boolean put(IFile parent, IFile generated, boolean isSource) {
        return this.put(parent, generated, isSource ? Collections.emptySet() : EnumSet.of(Flags.NONSOURCE));
    }

    public synchronized boolean put(IFile parent, IFile generated, Set<Flags> flags) {
        if (flags.isEmpty()) {
            this._flags.remove(generated);
        } else {
            this._flags.put(generated, flags);
        }
        return super.put(parent, generated);
    }

    public Set<Flags> getFlags(IFile generated) {
        Set<Flags> flags = this._flags.get(generated);
        return flags == null ? Collections.emptySet() : flags;
    }

    public boolean isSource(IFile generated) {
        return !this.getFlags(generated).contains((Object)Flags.NONSOURCE);
    }

    private String convertIFileToPath(IFile file) {
        IPath path = file.getProjectRelativePath();
        return path.toOSString();
    }

    private IFile convertPathToIFile(String projectRelativeString) {
        Path path = new Path(projectRelativeString);
        return this._proj.getFile((IPath)path);
    }

    private File getStateFile(IProject project, boolean isTestCode) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.apt.core");
        return workingLocation.append(isTestCode ? "teststate.dat" : "state.dat").toFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readState() {
        File file = this.getStateFile(this._proj, this._isTestCode);
        if (file == null || !file.exists()) {
            return;
        }
        FilterInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                int version = ((DataInputStream)in).readInt();
                if (version != 2) {
                    throw new IOException("Dependency map file version does not match. Expected 2, but found " + version);
                }
                int sizeOfMap = ((DataInputStream)in).readInt();
                int parentIndex = 0;
                while (parentIndex < sizeOfMap) {
                    String parentPath = ((DataInputStream)in).readUTF();
                    IFile parent = this.convertPathToIFile(parentPath);
                    int numChildren = ((DataInputStream)in).readInt();
                    int childIndex = 0;
                    while (childIndex < numChildren) {
                        String childPath = ((DataInputStream)in).readUTF();
                        IFile child = this.convertPathToIFile(childPath);
                        this.put(parent, child);
                        ++childIndex;
                    }
                    ++parentIndex;
                }
                int sizeOfFlags = ((DataInputStream)in).readInt();
                int i = 0;
                while (i < sizeOfFlags) {
                    String childPath = ((DataInputStream)in).readUTF();
                    IFile child = this.convertPathToIFile(childPath);
                    if (!this.containsValue(child)) {
                        throw new IOException("Error in generated file attributes: did not expect file " + childPath);
                    }
                    int attributeCount = ((DataInputStream)in).readInt();
                    EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);
                    int j = 0;
                    while (j < attributeCount) {
                        String attr = ((DataInputStream)in).readUTF();
                        Flags f = Flags.valueOf(attr);
                        flags.add(f);
                        ++j;
                    }
                    this._flags.put(child, flags);
                    ++i;
                }
                this.clearDirtyBit();
                return;
            }
            catch (IOException ioe) {
                this.clear();
                AptPlugin.logWarning(ioe, "Could not read APT dependencies: generated files may not be deleted until the next clean");
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IllegalArgumentException iae) {
                this.clear();
                AptPlugin.logWarning(iae, "Could not read APT dependencies: generated files may not be deleted until the next clean");
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void writeState() {
        block18: {
            if (!this.isDirty()) {
                return;
            }
            File file = this.getStateFile(this._proj, this._isTestCode);
            if (file == null) {
                return;
            }
            file.delete();
            FilterOutputStream out = null;
            try {
                try {
                    out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    ((DataOutputStream)out).writeInt(2);
                    Set parents = this.getKeySet();
                    ((DataOutputStream)out).writeInt(parents.size());
                    for (IFile iFile : parents) {
                        ((DataOutputStream)out).writeUTF(this.convertIFileToPath(iFile));
                        Set children = this.getValues(iFile);
                        ((DataOutputStream)out).writeInt(children.size());
                        for (IFile child : children) {
                            ((DataOutputStream)out).writeUTF(this.convertIFileToPath(child));
                        }
                    }
                    ((DataOutputStream)out).writeInt(this._flags.size());
                    for (Map.Entry entry : this._flags.entrySet()) {
                        ((DataOutputStream)out).writeUTF(this.convertIFileToPath((IFile)entry.getKey()));
                        Set flags = (Set)entry.getValue();
                        ((DataOutputStream)out).writeInt(flags.size());
                        for (Flags f : flags) {
                            ((DataOutputStream)out).writeUTF(f.name());
                        }
                    }
                    this.clearDirtyBit();
                    ((DataOutputStream)out).flush();
                }
                catch (IOException ioe) {
                    AptPlugin.logWarning(ioe, "Could not serialize APT dependencies");
                    if (out == null) break block18;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static enum Flags {
        NONSOURCE;

    }
}

