/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.dialogs.PatternFilter;

public class PluginWorkingSet
extends WizardPage
implements IWorkingSetPage {
    private IWorkingSet fWorkingSet;
    private Text fWorkingSetName;
    private CheckboxFilteredTree fTree;
    private boolean fFirstCheck;

    public PluginWorkingSet() {
        super("page1", PDEUIMessages.PluginWorkingSet_title, PDEPluginImages.DESC_DEFCON_WIZ);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void finish() {
        Object[] checked = this.fTree.getCheckboxTreeViewer().getCheckedElements();
        ArrayList<PersistablePluginObject> list = new ArrayList<PersistablePluginObject>();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            String id = ((IPluginModelBase)checkedElement).getPluginBase().getId();
            if (id != null && id.length() > 0) {
                list.add(new PersistablePluginObject(id));
            }
            ++n2;
        }
        PersistablePluginObject[] objects = list.toArray(new PersistablePluginObject[list.size()]);
        String workingSetName = this.fWorkingSetName.getText().trim();
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, (IAdaptable[])objects);
        } else {
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements((IAdaptable[])objects);
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(PDEUIMessages.PluginWorkingSet_setName);
        label.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(e -> this.validatePage());
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(PDEUIMessages.PluginWorkingSet_setContent);
        label.setLayoutData((Object)new GridData(768));
        this.fTree = new CheckboxFilteredTree(composite, 2048, new PatternFilter());
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fTree.getViewer().getControl().setLayoutData((Object)gd);
        ContentProvider fTableContentProvider = new ContentProvider();
        this.fTree.getCheckboxTreeViewer().setContentProvider((IContentProvider)fTableContentProvider);
        this.fTree.getCheckboxTreeViewer().setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTree.getCheckboxTreeViewer().setUseHashlookup(true);
        this.fTree.getCheckboxTreeViewer().setInput((Object)PDECore.getDefault());
        this.fTree.getCheckboxTreeViewer().addCheckStateListener(event -> this.validatePage());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(PDEUIMessages.PluginWorkingSet_selectAll_label);
        selectAllButton.setToolTipText(PDEUIMessages.PluginWorkingSet_selectAll_toolTip);
        selectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(arg_0 -> this.lambda$2((IStructuredContentProvider)fTableContentProvider, arg_0)));
        selectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(PDEUIMessages.PluginWorkingSet_deselectAll_label);
        deselectAllButton.setToolTipText(PDEUIMessages.PluginWorkingSet_deselectAll_toolTip);
        deselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            this.fTree.getCheckboxTreeViewer().setCheckedElements(new Object[0]);
            this.validatePage();
        }));
        deselectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deselectAllButton);
        this.setPageComplete(false);
        this.setMessage(PDEUIMessages.PluginWorkingSet_message);
        this.initialize();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.plugin_working_set");
    }

    private void initialize() {
        if (this.fWorkingSet != null) {
            IPluginModelBase[] bases;
            IAdaptable[] elements;
            HashSet<String> set = new HashSet<String>();
            IAdaptable[] iAdaptableArray = elements = this.fWorkingSet.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable element = iAdaptableArray[n2];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                }
                ++n2;
            }
            IPluginModelBase[] iPluginModelBaseArray = bases = PluginRegistry.getAllModels();
            int n3 = bases.length;
            n = 0;
            while (n < n3) {
                IPluginModelBase model = iPluginModelBaseArray[n];
                String id = model.getPluginBase().getId();
                if (id != null) {
                    if (set.contains(id)) {
                        this.fTree.getCheckboxTreeViewer().setChecked((Object)model, true);
                        set.remove(id);
                    }
                    if (set.isEmpty()) break;
                }
                ++n;
            }
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    private void validatePage() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (newText.trim().length() == 0) {
            errorMessage = PDEUIMessages.PluginWorkingSet_emptyName;
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
        }
        if (errorMessage == null && this.fTree.getCheckboxTreeViewer().getCheckedElements().length == 0) {
            errorMessage = PDEUIMessages.PluginWorkingSet_noPluginsChecked;
        }
        if (errorMessage == null && this.fWorkingSet == null) {
            IWorkingSet[] workingSets;
            IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                if (newText.equals(workingSet.getName())) {
                    errorMessage = PDEUIMessages.PluginWorkingSet_nameInUse;
                    break;
                }
                ++n2;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private /* synthetic */ void lambda$2(IStructuredContentProvider iStructuredContentProvider, SelectionEvent selectionEvent) {
        this.fTree.getCheckboxTreeViewer().setCheckedElements(iStructuredContentProvider.getElements(this.fTree.getCheckboxTreeViewer().getInput()));
        this.validatePage();
    }

    class CheckboxFilteredTree
    extends FilteredTree {
        public CheckboxFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CheckboxTreeViewer(parent, style);
        }

        public CheckboxTreeViewer getCheckboxTreeViewer() {
            return (CheckboxTreeViewer)this.getViewer();
        }
    }

    static class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PluginRegistry.getAllModels();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class WorkingSetLabelProvider
    extends LabelProvider {
        PDEPreferencesManager pref = PDEPlugin.getDefault().getPreferenceManager();

        public WorkingSetLabelProvider() {
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        }

        public String getText(Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginBase plugin = ((IPluginModelBase)element).getPluginBase();
                String showType = this.pref.getString("Preferences.MainPage.showObjects");
                if (showType.equals("useIds")) {
                    return plugin.getId();
                }
                return plugin.getTranslatedName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public void dispose() {
            super.dispose();
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        }
    }
}

