/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.jface.action.Action;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.refactoring.RefactoringInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class PDERefactoringAction
extends Action {
    private RefactoringInfo fInfo = null;

    public PDERefactoringAction(String label, RefactoringInfo info) {
        super(label);
        this.fInfo = info;
    }

    public void setSelection(Object selection) {
        this.fInfo.setSelection(selection);
    }

    public void run() {
        RefactoringProcessor processor = this.getRefactoringProcessor(this.fInfo);
        PDERefactor refactor = new PDERefactor(processor);
        RefactoringWizard wizard = this.getRefactoringWizard(refactor, this.fInfo);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
        try {
            op.run(this.getShell(), "");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public abstract RefactoringProcessor getRefactoringProcessor(RefactoringInfo var1);

    public abstract RefactoringWizard getRefactoringWizard(PDERefactor var1, RefactoringInfo var2);
}

