/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ColorManager
implements IColorManager,
IPDEColorConstants {
    private static ColorManager fColorManager;
    private final Map<String, Color> fColorTable = new HashMap<String, Color>(5);
    private static int counter;

    static {
        counter = 0;
    }

    public ColorManager() {
        this.initialize();
    }

    public static IColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new ColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        ColorManager.setDefault(store, "editor.color.default", DEFAULT);
        ColorManager.setDefault(store, "editor.color.instr", PROC_INSTR);
        ColorManager.setDefault(store, "editor.color.string", STRING);
        ColorManager.setDefault(store, "editor.color.externalized_string", EXTERNALIZED_STRING);
        ColorManager.setDefault(store, "editor.color.tag", TAG);
        ColorManager.setDefault(store, "editor.color.xml_comment", XML_COMMENT);
        ColorManager.setDefault(store, "editor.color.header_key", HEADER_KEY);
        ColorManager.setDefault(store, "editor.color.header_osgi", HEADER_OSGI);
        store.setDefault("editor.color.header_osgi_bold", true);
        ColorManager.setDefault(store, "editor.color.header_value", HEADER_VALUE);
        ColorManager.setDefault(store, "editor.color.header_attributes", HEADER_ATTRIBUTES);
        store.setDefault("editor.color.header_attributes_italic", true);
        ColorManager.setDefault(store, "editor.color.header_assignment", HEADER_ASSIGNMENT);
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        try {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = () -> {
                if (!display.isDisposed() && display.getHighContrast()) {
                    ColorManager.setDefault(store, "editor.color.default", DEFAULT_HIGH_CONTRAST);
                    ColorManager.setDefault(store, "editor.color.header_value", HEADER_VALUE_HIGH_CONTRAST);
                    ColorManager.setDefault(store, "editor.color.header_attributes", HEADER_ASSIGNMENT_HIGH_CONTRAST);
                }
            };
            if (display == Display.getCurrent()) {
                runnable.run();
            } else {
                display.asyncExec(runnable);
            }
        }
        catch (IllegalStateException | SWTException throwable) {
            // empty catch block
        }
    }

    private void initialize() {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.externalized_string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
        this.putColor(pstore, "editor.color.header_key");
        this.putColor(pstore, "editor.color.header_osgi");
        this.putColor(pstore, "editor.color.header_value");
        this.putColor(pstore, "editor.color.header_attributes");
        this.putColor(pstore, "editor.color.header_assignment");
        pstore = PreferenceConstants.getPreferenceStore();
        String[] stringArray = IColorManager.PROPERTIES_COLORS;
        int n = IColorManager.PROPERTIES_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String color = stringArray[n2];
            this.putColor(pstore, color);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        if (--counter == 0) {
            fColorManager = null;
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        this.putColor(property, PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property));
    }

    private void putColor(String property, RGB setting) {
        Color oldColor = this.fColorTable.get(property);
        if (oldColor != null && oldColor.getRGB().equals((Object)setting)) {
            return;
        }
        this.fColorTable.put(property, new Color((Device)Display.getCurrent(), setting));
    }

    @Override
    public Color getColor(String key) {
        Color color = this.fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }

    @Override
    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Object color = event.getNewValue();
        if (color instanceof RGB) {
            this.putColor(event.getProperty(), (RGB)color);
        } else {
            this.putColor(event.getProperty(), StringConverter.asRGB((String)color.toString()));
        }
    }

    private static void setDefault(IPreferenceStore store, String name, RGB value) {
        store.setDefault(name, StringConverter.asString((RGB)value));
    }
}

