/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginParentNode;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.search.ExtensionsPatternFilter;
import org.eclipse.swt.widgets.TreeItem;

public class ToggleExpandStateAction
extends Action {
    public static int NEEDS_EXPAND = 1;
    public static int NEEDS_COLLAPSE = 2;
    protected TreeViewer fExtensionTree;
    protected FormFilteredTree fFilteredTree;

    public ToggleExpandStateAction(FormFilteredTree filteredTree, TreeViewer treeViewer) {
        this.setImageDescriptor(PDEPluginImages.DESC_TOGGLE_EXPAND_STATE);
        this.setText(PDEUIMessages.ExtensionsPage_toggleExpandState);
        this.fExtensionTree = treeViewer;
        this.fFilteredTree = filteredTree;
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.fExtensionTree.getSelection();
        if (this.fExtensionTree.getTree().getSelectionCount() > 0) {
            TreeItem[] items = this.fExtensionTree.getTree().getSelection();
            try {
                this.fFilteredTree.setRedraw(false);
                int state = this.getStateChangeRequired(items);
                this.toggleExpandState(state, selection);
            }
            finally {
                this.fFilteredTree.setRedraw(true);
                this.fExtensionTree.refresh();
            }
        }
    }

    public void toggleExpandState(int state, StructuredSelection selection) {
        TreeItem[] items = this.fExtensionTree.getTree().getSelection();
        if (state == NEEDS_EXPAND) {
            this.traverseChildrenAndSetExpanded(items);
            this.fExtensionTree.refresh();
            this.expandChildrenElements(selection.toArray(), true);
            this.fExtensionTree.setSelection((ISelection)selection, false);
        } else {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.fExtensionTree.setExpandedState(iterator.next(), false);
            }
        }
    }

    public int getStateChangeRequired(TreeItem[] selection) {
        return this.traverseStateChangeRequired(selection) ? NEEDS_EXPAND : NEEDS_COLLAPSE;
    }

    protected boolean traverseStateChangeRequired(TreeItem[] items) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                TreeItem[] children = item.getItems();
                if (children.length > 0) {
                    if (item.getExpanded()) {
                        if (this.traverseStateChangeRequired(children)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void traverseChildrenAndSetExpanded(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item;
            TreeItem treeItem = item = treeItemArray[n2];
            TreeItem[] children = treeItem.getItems();
            int extensionsChildCount = this.getExtensionsChildCount((IPluginParent)treeItem.getData());
            boolean furtherExpanding = extensionsChildCount <= 1 || treeItem.getExpanded();
            treeItem.setExpanded(furtherExpanding);
            if (furtherExpanding) {
                this.traverseChildrenAndSetExpanded(children);
            }
            ++n2;
        }
    }

    private int getExtensionsChildCount(IPluginParent leafData) {
        int extensionsChildCount = 0;
        if (leafData != null && leafData instanceof PluginExtensionNode) {
            if (!this.fFilteredTree.isFiltered()) {
                return leafData.getChildCount();
            }
            ExtensionsPatternFilter filter = (ExtensionsPatternFilter)this.fFilteredTree.getPatternFilter();
            int j = 0;
            while (j < leafData.getChildCount()) {
                if (filter.containsElement(leafData.getChildren()[j])) {
                    ++extensionsChildCount;
                }
                ++j;
            }
        }
        return extensionsChildCount;
    }

    private void expandChildrenElements(Object[] children, boolean fullExpand) {
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof PluginParentNode) {
                PluginParentNode node = (PluginParentNode)child;
                if (node.getChildCount() > 0 && fullExpand) {
                    boolean furtherExpanding = !(node instanceof PluginExtensionNode) || this.fExtensionTree.getExpandedState((Object)node);
                    this.expandChildrenElements(node.getChildren(), furtherExpanding);
                } else {
                    this.fExtensionTree.expandToLevel((Object)node, 0);
                }
            }
            ++n2;
        }
    }

    public static boolean isExpandable(IStructuredSelection selection) {
        boolean isExpandable = false;
        if (selection != null && !selection.isEmpty()) {
            for (Object element : selection) {
                PluginParentNode node;
                if (!(element instanceof PluginParentNode) || (node = (PluginParentNode)element).getChildCount() <= 0) continue;
                isExpandable = true;
                break;
            }
        }
        return isExpandable;
    }
}

