/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.WorkspaceRepository;
import aQute.bnd.osgi.Builder;
import aQute.bnd.service.IndexProvider;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResolutionPhase;
import aQute.bnd.version.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.bnd.ui.model.repo.LoadingContentElement;
import org.eclipse.pde.bnd.ui.model.repo.ProjectBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryResourceElement;
import org.eclipse.pde.bnd.ui.plugins.EclipseWorkspaceRepository;
import org.eclipse.swt.widgets.Display;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class RepositoryTreeContentProvider
implements ITreeContentProvider {
    private static final String CACHE_REPOSITORY = "cache";
    private final EnumSet<ResolutionPhase> phases;
    private String rawFilter = null;
    private String wildcardFilter = null;
    private static final int MAX_CACHED_FILTER_RESULTS = 10;
    private boolean showRepos = true;
    private Requirement requirementFilter = null;
    private final Map<RepositoryPlugin, Map<String, Object[]>> repoPluginListResults = new HashMap<RepositoryPlugin, Map<String, Object[]>>();
    private StructuredViewer structuredViewer;

    public RepositoryTreeContentProvider() {
        this.phases = EnumSet.allOf(ResolutionPhase.class);
    }

    public RepositoryTreeContentProvider(ResolutionPhase mode) {
        this.phases = EnumSet.of(mode);
    }

    public RepositoryTreeContentProvider(EnumSet<ResolutionPhase> modes) {
        this.phases = modes;
    }

    public String getFilter() {
        return this.rawFilter;
    }

    public void setFilter(String filter) {
        this.rawFilter = filter;
        this.wildcardFilter = filter == null || filter.length() == 0 || filter.trim().equals("*") ? null : "*" + filter.trim() + "*";
    }

    public void setRequirementFilter(Requirement requirement) {
        this.requirementFilter = requirement;
    }

    public void setShowRepos(boolean showRepos) {
        this.showRepos = showRepos;
    }

    public boolean isShowRepos() {
        return this.showRepos;
    }

    public Object[] getElements(Object inputElement) {
        List<Object> result;
        if (inputElement instanceof Workspace) {
            Workspace workspace = (Workspace)inputElement;
            result = new ArrayList();
            this.addRepositoryPlugins(result, workspace);
        } else if (inputElement instanceof Collection) {
            result = new ArrayList();
            this.addCollection(result, (Collection)inputElement);
        } else if (inputElement instanceof Object[]) {
            result = new ArrayList();
            this.addCollection(result, Arrays.asList(inputElement));
        } else {
            result = Collections.emptyList();
        }
        return result.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.structuredViewer = (StructuredViewer)viewer;
            if (oldInput != null) {
                this.repoPluginListResults.clear();
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = null;
        if (parentElement instanceof RepositoryPlugin) {
            RepositoryPlugin repo = (RepositoryPlugin)parentElement;
            result = this.getRepositoryBundles(repo);
        } else if (parentElement instanceof RepositoryBundle) {
            RepositoryBundle bundle = (RepositoryBundle)parentElement;
            result = this.getRepositoryBundleVersions(bundle);
        } else if (parentElement instanceof Project) {
            Project project = (Project)parentElement;
            result = this.getProjectBundles(project);
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof RepositoryBundle) {
            return ((RepositoryBundle)element).getRepo();
        }
        if (element instanceof RepositoryBundleVersion) {
            return ((RepositoryBundleVersion)element).getParentBundle();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof RepositoryPlugin || element instanceof RepositoryBundle || element instanceof Project;
    }

    private void addRepositoryPlugins(Collection<Object> result, Workspace workspace) {
        workspace.getErrors().clear();
        List repoPlugins = workspace.getPlugins(RepositoryPlugin.class);
        ILog log = ILog.get();
        for (String error : workspace.getErrors()) {
            log.error(error);
        }
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            IndexProvider indexProvider;
            if (CACHE_REPOSITORY.equals(repoPlugin.getName()) || repoPlugin instanceof IndexProvider && !this.supportsPhase(indexProvider = (IndexProvider)repoPlugin)) continue;
            if (this.showRepos) {
                result.add(repoPlugin);
                continue;
            }
            result.addAll(Arrays.asList(this.getRepositoryBundles(repoPlugin)));
        }
    }

    private void addCollection(Collection<Object> result, Collection<Object> inputs) {
        for (Object input : inputs) {
            RepositoryPlugin repo;
            if (!(input instanceof RepositoryPlugin) || (repo = (RepositoryPlugin)input) instanceof IndexProvider && !this.supportsPhase((IndexProvider)repo)) continue;
            if (this.showRepos) {
                result.add(repo);
                continue;
            }
            Object[] bundles = this.getRepositoryBundles(repo);
            if (bundles == null || bundles.length <= 0) continue;
            result.addAll(Arrays.asList(bundles));
        }
    }

    private boolean supportsPhase(IndexProvider provider) {
        Set supportedPhases = provider.getSupportedPhases();
        for (ResolutionPhase phase : this.phases) {
            if (!supportedPhases.contains(phase)) continue;
            return true;
        }
        return false;
    }

    Object[] getProjectBundles(Project project) {
        ProjectBundle[] result = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ProjectBuilder pb = project.getBuilder(null);){
                List builders = pb.getSubBuilders();
                result = new ProjectBundle[builders.size()];
                int i = 0;
                for (Builder builder : builders) {
                    ProjectBundle bundle = new ProjectBundle(project, builder.getBsn());
                    result[i++] = bundle;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ILog.get().error(MessageFormat.format("Error querying sub-bundles for project {0}.", project.getName()), (Throwable)e);
        }
        return result;
    }

    Object[] getRepositoryBundleVersions(RepositoryBundle bundle) {
        SortedSet versions = null;
        try {
            versions = bundle.getRepo().versions(bundle.getBsn());
        }
        catch (Exception e) {
            ILog.get().error(MessageFormat.format("Error querying versions for bundle {0} in repository {1}.", bundle.getBsn(), bundle.getRepo().getName()), (Throwable)e);
        }
        if (versions != null) {
            Stream<RepositoryBundleVersion> resultStream = versions.stream().map(version -> new RepositoryBundleVersion(bundle, (Version)version));
            if (bundle.getBsn().indexOf(":") != -1) {
                resultStream = resultStream.filter(rbv -> rbv.getText().contains("Not a bundle"));
            }
            return resultStream.toArray(RepositoryBundleVersion[]::new);
        }
        return null;
    }

    Object[] getRepositoryBundles(final RepositoryPlugin repoPlugin) {
        Object[] result = null;
        if (this.requirementFilter != null) {
            if (repoPlugin instanceof Repository) {
                result = this.searchR5Repository(repoPlugin, (Repository)repoPlugin);
            } else if (repoPlugin instanceof WorkspaceRepository) {
                try {
                    EclipseWorkspaceRepository workspaceRepo = EclipseWorkspaceRepository.get(ResourcesPlugin.getWorkspace());
                    result = this.searchR5Repository(repoPlugin, (Repository)workspaceRepo);
                }
                catch (Exception e) {
                    ILog.get().error("Error querying workspace repository", (Throwable)e);
                }
            }
            return result;
        }
        Map listResults = this.repoPluginListResults.computeIfAbsent(repoPlugin, p -> RepositoryTreeContentProvider.createLRUMap(10));
        result = (Object[])listResults.get(this.wildcardFilter);
        if (result == null) {
            Job job = new Job("Loading " + repoPlugin.getName() + " content..."){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    List bsns = null;
                    try {
                        bsns = repoPlugin.list(RepositoryTreeContentProvider.this.wildcardFilter);
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format("Error querying repository {0}.", repoPlugin.getName());
                        ILog.get().error(message, (Throwable)e);
                        status = Status.error((String)message, (Throwable)e);
                    }
                    if (bsns != null) {
                        Collections.sort(bsns);
                        RepositoryBundle[] jobresult = new RepositoryBundle[bsns.size()];
                        int i = 0;
                        for (String bsn : bsns) {
                            jobresult[i++] = new RepositoryBundle(repoPlugin, bsn);
                        }
                        Map listResults = RepositoryTreeContentProvider.this.repoPluginListResults.computeIfAbsent(repoPlugin, p -> RepositoryTreeContentProvider.createLRUMap(10));
                        listResults.put(RepositoryTreeContentProvider.this.wildcardFilter, jobresult);
                        Display.getDefault().asyncExec(() -> {
                            if (!RepositoryTreeContentProvider.this.structuredViewer.getControl().isDisposed()) {
                                RepositoryTreeContentProvider.this.structuredViewer.refresh((Object)repoPlugin, true);
                            }
                        });
                    }
                    return status;
                }
            };
            job.schedule();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IStatus status = job.getResult();
            if (status != null && status.isOK()) {
                Map fastResults = this.repoPluginListResults.computeIfAbsent(repoPlugin, p -> RepositoryTreeContentProvider.createLRUMap(10));
                result = (Object[])fastResults.get(this.wildcardFilter);
            } else {
                Object[] loading = new Object[]{new LoadingContentElement()};
                listResults.put(this.wildcardFilter, loading);
                result = loading;
            }
        }
        return result;
    }

    private Object[] searchR5Repository(RepositoryPlugin repoPlugin, Repository osgiRepo) {
        LinkedHashSet<RepositoryResourceElement> resultSet = new LinkedHashSet<RepositoryResourceElement>();
        Map providers = osgiRepo.findProviders(Collections.singleton(this.requirementFilter));
        for (Map.Entry providersEntry : providers.entrySet()) {
            for (Capability providerCap : (Collection)providersEntry.getValue()) {
                resultSet.add(new RepositoryResourceElement(repoPlugin, providerCap.getResource()));
            }
        }
        Object[] result = resultSet.toArray();
        return result;
    }

    private static Map<String, Object[]> createLRUMap(final int n) {
        return new LinkedHashMap<String, Object[]>(n + 1, 1.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
                return this.size() > n && eldest.getKey() != null;
            }
        };
    }
}

