/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Version;

public final class DependencyResolver {
    private final ListMultimap<String, IPluginModelBase> dependecies;
    private final Map<IPluginModelBase, Boolean> visit = new HashMap<IPluginModelBase, Boolean>();

    public DependencyResolver(ListMultimap<String, IPluginModelBase> fAllBundles) {
        Objects.requireNonNull(fAllBundles);
        this.dependecies = fAllBundles;
    }

    public Collection<IPluginModelBase> checkPlugins(Collection<IPluginModelBase> toCheckDeps) {
        Objects.requireNonNull(toCheckDeps);
        this.visit.clear();
        ArrayList toRemove = new ArrayList();
        toCheckDeps.forEach(dep -> {
            if (!this.checkPlugin((IPluginModelBase)dep)) {
                toRemove.add(dep);
            }
        });
        return Collections.unmodifiableList(toRemove);
    }

    private boolean checkPlugin(IPluginModelBase plugin) {
        if (plugin == null) {
            return false;
        }
        if (this.visit.containsKey(plugin)) {
            return this.visit.get(plugin);
        }
        BundleSpecification[] bundleSpecificationArray = plugin.getBundleDescription().getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification dep = bundleSpecificationArray[n2];
            if (!dep.isOptional()) {
                if (!this.dependecies.containsKey((Object)dep.getName())) {
                    this.visit.put(plugin, false);
                    return false;
                }
                List<IPluginModelBase> candidates = this.dependecies.get((Object)dep.getName()).stream().filter(p -> dep.getVersionRange().isIncluded(new Version(p.getPluginBase().getVersion()))).toList();
                if (candidates.isEmpty()) {
                    this.visit.put(plugin, false);
                    return false;
                }
                this.visit.put(plugin, true);
                if (!candidates.stream().anyMatch(this::checkPlugin)) {
                    this.visit.put(plugin, false);
                    return false;
                }
            }
            ++n2;
        }
        this.visit.put(plugin, true);
        return true;
    }
}

