/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.ui.util.ManipulationsCommonUtilMessages;

public class ResourcesUtility {
    private ResourcesUtility() {
    }

    public static void createDerivedFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ResourcesUtility.createDerivedFolder((IFolder)parent, force, local, null);
            }
            folder.create(force ? 1025 : 1024, local, monitor);
        }
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ResourcesUtility.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static IFile[] getFiles(ICompilationUnit[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        ICompilationUnit[] iCompilationUnitArray = cus;
        int n = cus.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            IResource resource = cu.getResource();
            if (resource != null && resource.getType() == 1) {
                files.add(resource);
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile getFile(ICompilationUnit cu) {
        IResource resource = cu.getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IJavaElement) {
            return ResourcesUtility.getResource((IJavaElement)o);
        }
        return null;
    }

    public static IResource getResource(IJavaElement element) {
        if (element.getElementType() == 5) {
            return element.getResource();
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)ManipulationsCommonUtilMessages.BuildPathsBlock_operationdesc_project, (int)2);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (locationURI != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(locationURI)) {
                    locationURI = null;
                }
                desc.setLocationURI(locationURI);
                project.create(desc, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            subMonitor.done();
        }
    }
}

