/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.ChangeCalculator;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.ContextCalculator;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.FinalConditionsChecker;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.InitialConditionsChecker;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MakeStaticRefactoring
extends Refactoring {
    private RefactoringStatus fStatus;
    private ContextCalculator fContextCalculator;
    private ChangeCalculator fChangeCalculator;

    public MakeStaticRefactoring(ICompilationUnit inputAsICompilationUnit, int selectionStart, int selectionLength) {
        Selection targetSelection = Selection.createFromStartLength(selectionStart, selectionLength);
        this.fContextCalculator = new ContextCalculator(inputAsICompilationUnit, targetSelection);
    }

    public MakeStaticRefactoring(IMethod method) {
        this.fContextCalculator = new ContextCalculator(method);
    }

    public String getName() {
        return RefactoringCoreMessages.MakeStaticRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor progressMonitor) throws JavaModelException {
        this.fStatus = new RefactoringStatus();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)RefactoringCoreMessages.MakeStaticRefactoring_checking_preconditions, (int)10);
        ContextCalculator.SelectionInputType selectionInputType = this.fContextCalculator.getSelectionInputType();
        InitialConditionsChecker checker = new InitialConditionsChecker(this.fStatus);
        if (selectionInputType == ContextCalculator.SelectionInputType.TEXT_SELECTION) {
            if (!checker.checkValidTextSelectionStart(this.fContextCalculator.getSelectionEditorText())) {
                return this.fStatus;
            }
            if (!checker.checkValidICompilationUnit(this.fContextCalculator.getSelectionICompilationUnit())) {
                return this.fStatus;
            }
            if (!checker.checkASTNodeIsValidMethod(this.fContextCalculator.getOrComputeSelectionASTNode())) {
                return this.fStatus;
            }
        }
        progress.split(3);
        if (!checker.checkSourceAvailable(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkValidIMethod(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkValidICompilationUnit(this.fContextCalculator.getOrComputeTargetICompilationUnit())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkMethodIsNotConstructor(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkMethodNotInLocalOrAnonymousClass(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkMethodNotStatic(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        if (!checker.checkMethodNotOverridden(this.fContextCalculator.getOrComputeTargetIMethod())) {
            return this.fStatus;
        }
        progress.split(1);
        return this.fStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)RefactoringCoreMessages.MakeStaticRefactoring_checking_conditions, (int)8);
        this.fStatus = new RefactoringStatus();
        FinalConditionsChecker checker = new FinalConditionsChecker(this.fStatus);
        this.fChangeCalculator = new ChangeCalculator(this.fContextCalculator.getOrComputeTargetMethodDeclaration(), this.fContextCalculator.getOrComputeTargetIMethod(), checker);
        progress.split(1);
        this.fChangeCalculator.modifyMethodDeclaration();
        progress.split(6);
        this.fChangeCalculator.handleMethodInvocations(progress.slice(1), this.fContextCalculator.getOrComputeTargetIMethodBinding());
        progress.split(1);
        return this.fStatus;
    }

    public Change createChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)RefactoringCoreMessages.MakeStaticRefactoring_creating_changes, (int)1);
        CompositeChange multiChange = new CompositeChange(RefactoringCoreMessages.MakeStaticRefactoring_name, (Change[])this.fChangeCalculator.getOrComputeChanges());
        progress.split(1);
        return multiChange;
    }
}

