/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import java.util.Collection;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class CountExpression
extends Expression {
    private static final int GREATER_THAN_OR_EQUAL = 9;
    private static final int LESS_THAN_OR_EQUAL = 8;
    private static final int GREATER_THAN = 7;
    private static final int LESS_THAN = 6;
    private static final int ANY_NUMBER = 5;
    private static final int EXACT = 4;
    private static final int ONE_OR_MORE = 3;
    private static final int NONE_OR_ONE = 2;
    private static final int NONE = 1;
    private static final int UNKNOWN = 0;
    private static final int HASH_INITIAL = CountExpression.class.getName().hashCode();
    private int fMode;
    private int fSize;

    public CountExpression(IConfigurationElement configElement) {
        String size = configElement.getAttribute("value");
        this.initializeSize(size);
    }

    public CountExpression(Element element) {
        String size = element.getAttribute("value");
        this.initializeSize(size.isEmpty() ? null : size);
    }

    public CountExpression(String size) {
        this.initializeSize(size);
    }

    private void initializeSize(String size) {
        if (size == null) {
            size = "*";
        }
        if ("*".equals(size)) {
            this.fMode = 5;
        } else if ("?".equals(size)) {
            this.fMode = 2;
        } else if ("!".equals(size)) {
            this.fMode = 1;
        } else if ("+".equals(size)) {
            this.fMode = 3;
        } else if (size.charAt(0) == '-' && size.charAt(size.length() - 1) == ')') {
            try {
                this.fMode = 6;
                this.fSize = Integer.parseInt(size.substring(1, size.length() - 1));
            }
            catch (NumberFormatException e) {
                this.fMode = 0;
            }
        } else if (size.charAt(0) == '-' && size.charAt(size.length() - 1) == ']') {
            try {
                this.fMode = 8;
                this.fSize = Integer.parseInt(size.substring(1, size.length() - 1));
            }
            catch (NumberFormatException e) {
                this.fMode = 0;
            }
        } else if (size.charAt(0) == '(' && size.charAt(size.length() - 1) == '-') {
            try {
                this.fMode = 7;
                this.fSize = Integer.parseInt(size.substring(1, size.length() - 1));
            }
            catch (NumberFormatException e) {
                this.fMode = 0;
            }
        } else if (size.charAt(0) == '[' && size.charAt(size.length() - 1) == '-') {
            try {
                this.fMode = 9;
                this.fSize = Integer.parseInt(size.substring(1, size.length() - 1));
            }
            catch (NumberFormatException e) {
                this.fMode = 0;
            }
        } else {
            try {
                this.fSize = Integer.parseInt(size);
                this.fMode = 4;
            }
            catch (NumberFormatException e) {
                this.fMode = 0;
            }
        }
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        int size;
        Object var = context.getDefaultVariable();
        if (var instanceof Collection) {
            Collection collection = (Collection)var;
            size = collection.size();
        } else {
            ICountable countable = Expressions.getAsICountable(var, this);
            if (countable == null) {
                return EvaluationResult.NOT_LOADED;
            }
            size = countable.count();
        }
        switch (this.fMode) {
            case 0: {
                return EvaluationResult.FALSE;
            }
            case 1: {
                return EvaluationResult.valueOf(size == 0);
            }
            case 2: {
                return EvaluationResult.valueOf(size == 0 || size == 1);
            }
            case 3: {
                return EvaluationResult.valueOf(size >= 1);
            }
            case 4: {
                return EvaluationResult.valueOf(this.fSize == size);
            }
            case 5: {
                return EvaluationResult.TRUE;
            }
            case 6: {
                return EvaluationResult.valueOf(size < this.fSize);
            }
            case 7: {
                return EvaluationResult.valueOf(size > this.fSize);
            }
            case 8: {
                return EvaluationResult.valueOf(size <= this.fSize);
            }
            case 9: {
                return EvaluationResult.valueOf(size >= this.fSize);
            }
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void that;
        if (!(object instanceof CountExpression)) {
            return false;
        }
        CountExpression countExpression = (CountExpression)object;
        return this.fMode == that.fMode && this.fSize == that.fSize;
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fMode * 89 + this.fSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [ size=");
        builder.append(this.fSize);
        builder.append(", mode: ");
        builder.append(this.fMode);
        switch (this.fMode) {
            case 9: {
                builder.append(" GREATER_THAN_OR_EQUAL");
                break;
            }
            case 8: {
                builder.append(" LESS_THAN_OR_EQUAL");
                break;
            }
            case 7: {
                builder.append(" GREATER_THAN");
                break;
            }
            case 6: {
                builder.append(" LESS_THAN");
                break;
            }
            case 5: {
                builder.append(" ANY_NUMBER");
                break;
            }
            case 4: {
                builder.append(" EXACT");
                break;
            }
            case 3: {
                builder.append(" ONE_OR_MORE");
                break;
            }
            case 2: {
                builder.append(" NONE_OR_ONE");
                break;
            }
            case 1: {
                builder.append(" NONE");
                break;
            }
            case 0: {
                builder.append(" UNKNOWN");
                break;
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

