/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IAddMemoryBlocksTarget;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.ui.IWorkbenchPart;

public class RetargetAddMemoryBlockAction
extends AddMemoryBlockAction {
    public RetargetAddMemoryBlockAction(IMemoryRenderingSite site) {
        super(site);
    }

    public RetargetAddMemoryBlockAction(IMemoryRenderingSite site, boolean addDefaultRenderings) {
        super(site, addDefaultRenderings);
    }

    public RetargetAddMemoryBlockAction(String text, int style, IMemoryRenderingSite site) {
        super(text, style, site);
    }

    @Override
    public void run() {
        block5: {
            IAdaptable debugContext = DebugUITools.getPartDebugContext(this.fSite.getSite());
            IAddMemoryBlocksTarget target = this.getAddMemoryBlocksTarget(debugContext);
            if (target != null) {
                try {
                    if (target.supportsAddMemoryBlocks((IWorkbenchPart)this.getMemoryView())) {
                        target.addMemoryBlocks((IWorkbenchPart)this.getMemoryView(), this.getMemoryView().getSite().getSelectionProvider().getSelection());
                        break block5;
                    }
                    super.run();
                }
                catch (CoreException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.RetargetAddMemoryBlockAction_0, ActionMessages.RetargetAddMemoryBlockAction_1, e);
                }
            } else {
                super.run();
            }
        }
    }

    @Override
    protected void updateAction(Object debugContext) {
        try {
            IAddMemoryBlocksTarget target = this.getAddMemoryBlocksTarget(debugContext);
            if (target != null) {
                if (target.supportsAddMemoryBlocks((IWorkbenchPart)this.getMemoryView())) {
                    if (this.getMemoryView().getSite().getSelectionProvider() != null) {
                        this.setEnabled(target.canAddMemoryBlocks((IWorkbenchPart)this.getMemoryView(), this.getMemoryView().getSite().getSelectionProvider().getSelection()));
                    } else {
                        super.updateAction(debugContext);
                    }
                } else {
                    super.updateAction(debugContext);
                }
            } else {
                super.updateAction(debugContext);
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private IAddMemoryBlocksTarget getAddMemoryBlocksTarget(Object debugContext) {
        IMemoryBlockRetrieval standardMemRetrieval = MemoryViewUtil.getMemoryBlockRetrieval(debugContext);
        if (standardMemRetrieval == null) {
            return null;
        }
        IAddMemoryBlocksTarget target = null;
        if (standardMemRetrieval instanceof IAddMemoryBlocksTarget) {
            target = (IAddMemoryBlocksTarget)standardMemRetrieval;
        } else if (standardMemRetrieval instanceof IAdaptable) {
            target = (IAddMemoryBlocksTarget)((IAdaptable)standardMemRetrieval).getAdapter(IAddMemoryBlocksTarget.class);
        }
        return target;
    }
}

