/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.ui.utils.MinimizedFileSystemElement;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.ide.filesystem.FileSystemStructureProvider;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class WizardFileSystemResourceImportPage1
extends WizardPage
implements Listener,
IOverwriteQuery {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureButton;
    protected Button createOnlySelectedButton;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private Text containerNameField;
    protected List selectedTypes = new ArrayList();
    protected ResourceTreeAndListGroup selectionGroup;
    private boolean entryChanged = false;
    private FileSystemStructureProvider fileSystemStructureProvider = new FileSystemStructureProvider();
    protected static final int COMBO_HISTORY_LENGTH = 5;
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardFileSystemResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String SELECT_TYPES_TITLE = DataTransferMessages.DataTransfer_selectTypes;
    private static final String SELECT_ALL_TITLE = DataTransferMessages.DataTransfer_selectAll;
    private static final String DESELECT_ALL_TITLE = DataTransferMessages.DataTransfer_deselectAll;
    private static final String SELECT_SOURCE_TITLE = DataTransferMessages.FileImport_selectSourceTitle;
    private static final String SELECT_SOURCE_MESSAGE = DataTransferMessages.FileImport_selectSource;
    protected static final String SOURCE_EMPTY_MESSAGE = DataTransferMessages.FileImport_sourceEmpty;
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private WSContainer container;

    public WizardFileSystemResourceImportPage1(WSContainer container) {
        super("fileSystemImportPage1");
        this.setTitle("File system");
        this.setDescription("Import resources from the local file system.");
        this.container = container;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(parent.getFont());
        GridData buttonData = new GridData(272);
        buttonData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)buttonData);
        this.selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectTypesButton);
        this.selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(true);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectAllButton);
        this.deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(false);
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.deselectAllButton);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.validateSourceGroup();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_import_wizard_page");
    }

    protected void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(IDEWorkbenchMessages.WizardExportPage_options);
        optionsGroup.setFont(parent.getFont());
        this.createOptionsGroupButtons(optionsGroup);
    }

    protected boolean determinePageCompletion() {
        boolean complete = this.validateSourceGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected final void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(IDEWorkbenchMessages.WizardImportPage_folder);
        resourcesLabel.setFont(parent.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(parent.getFont());
        this.containerNameField.setEnabled(false);
        this.containerNameField.setText(WSUtils.getPath((WSResource)this.container).toString());
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.overwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.createContainerStructureButton = new Button((Composite)optionsGroup, 16);
        this.createContainerStructureButton.setFont(optionsGroup.getFont());
        this.createContainerStructureButton.setText("Complete folder structure");
        this.createContainerStructureButton.setSelection(false);
        this.createOnlySelectedButton = new Button((Composite)optionsGroup, 16);
        this.createOnlySelectedButton.setFont(optionsGroup.getFont());
        this.createOnlySelectedButton.setText("Selected folders only");
        this.createOnlySelectedButton.setSelection(true);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                WizardFileSystemResourceImportPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (WizardFileSystemResourceImportPage1.this.entryChanged) {
                    WizardFileSystemResourceImportPage1.this.entryChanged = false;
                    WizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, (FileSystemElement)dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.selectionGroup = new ResourceTreeAndListGroup(parent, (Object)new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardFileSystemResourceImportPage1.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.selectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.selectionGroup.setListComparator((ViewerComparator)comparator);
        this.selectionGroup.addCheckStateListener(listener);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectTypesButton.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.setErrorMessage(DataTransferMessages.FileImport_invalidSource);
        return false;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message, (int)0x10000000);
    }

    protected void displayErrorDialog(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_exceptionMessage, (Object)exception);
        }
        this.displayErrorDialog(message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    protected List getSelectedResources() {
        return this.selectionGroup.getAllCheckedListItems();
    }

    protected void getSelectedResources(IElementFilter filter, IProgressMonitor monitor) throws InterruptedException {
        this.selectionGroup.getAllCheckedListItems((org.eclipse.ui.ide.dialogs.IElementFilter)filter, monitor);
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        if (fileSystemObjects.size() > 0) {
            return this.importResources(fileSystemObjects);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_information, (String)DataTransferMessages.FileImport_noneSelected);
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFiles((IImportStructureProvider)WizardFileSystemResourceImportPage1.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, (IImportStructureProvider)this.fileSystemStructureProvider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFolders((IImportStructureProvider)WizardFileSystemResourceImportPage1.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    if (element.isPopulated()) {
                        return this.getChildren(element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.FileImport_fromDirectory;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        Widget source = event.widget;
        this.updateWidgetEnablements();
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 0x10002000);
        dialog.setText(SELECT_SOURCE_TITLE);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    protected void handleTypesEditButtonPressed() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.getContainer().getShell(), (Collection)this.getTypesToImport());
        dialog.open();
        Object[] newSelectedTypes = dialog.getResult();
        if (newSelectedTypes != null) {
            this.selectedTypes = new ArrayList(newSelectedTypes.length);
            int i = 0;
            while (i < newSelectedTypes.length) {
                this.selectedTypes.add(newSelectedTypes[i]);
                ++i;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected List getTypesToImport() {
        return this.selectedTypes;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean importResources(List fileSystemObjects) {
        minimalRoot = null;
        model = PersistenceManager.getInstance().getModel(this.container.eResource());
        if (model == null) {
            return false;
        }
        for (E object : fileSystemObjects) {
            lpath = this.fileSystemStructureProvider.getFullPath(object);
            path = new Path(lpath).removeLastSegments(1);
            if (minimalRoot != null) ** GOTO lbl12
            minimalRoot = path;
            continue;
lbl-1000:
            // 1 sources

            {
                minimalRoot = minimalRoot.removeLastSegments(1);
lbl12:
                // 2 sources

                ** while (!minimalRoot.isPrefixOf((IPath)path))
            }
lbl13:
            // 1 sources

            if (path.segmentCount() >= minimalRoot.segmentCount()) continue;
            minimalRoot = path;
        }
        for (E object : fileSystemObjects) {
            if (this.fileSystemStructureProvider.isFolder(object) || !((folder = this.getFolder(this.container, (fullPath = new Path(this.fileSystemStructureProvider.getFullPath(object)).removeFirstSegments(minimalRoot.segmentCount())).removeLastSegments(1))) instanceof WSFolder)) continue;
            wsFile = WSUtils.getFile((WSFolder)((WSFolder)folder), (String)fullPath.lastSegment(), (boolean)true);
            fName = ImportUtils.getName((WSFile)wsFile);
            store = model.store(fName);
            inputStream = this.fileSystemStructureProvider.getContents(object);
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)store);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private WSContainer getFolder(WSContainer container, IPath segms) {
        WSFolder result = (WSFolder)container;
        String[] stringArray = segms.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = WSUtils.getContainer((WSContainer)result, (String)part, (boolean)true);
            ++n2;
        }
        return result;
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator itr = this.selectedTypes.iterator();
        while (itr.hasNext()) {
            if (!extension.equalsIgnoreCase((String)itr.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            boolean createStructure = settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
            this.createContainerStructureButton.setSelection(createStructure);
            this.createOnlySelectedButton.setSelection(!createStructure);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createContainerStructureButton.getSelection());
        }
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = WizardFileSystemResourceImportPage1.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        this.selectionGroup.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)fileElement;
                if (WizardFileSystemResourceImportPage1.this.isExportableExtension(file.getFileNameExtension())) {
                    List<Object> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                monitor.beginTask(DataTransferMessages.ImportPage_filterSelections, -1);
                WizardFileSystemResourceImportPage1.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException exception) {
            return;
        }
        catch (InterruptedException exception) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.sourceNameField.setFocus();
        }
    }

    protected void updateSelections(final Map map) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WizardFileSystemResourceImportPage1.this.selectionGroup.updateSelections(map);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        this.enableButtonGroup(this.ensureSourceIsValid());
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        List resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }

    protected final String getSourceConflictMessage() {
        return IDEWorkbenchMessages.WizardImportPage_importOnReceiver;
    }
}

