/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.ui.viewers;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.rcptt.internal.ui.FileImages;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.swt.graphics.Image;

public class WorkspaceLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private FileImages fileImages = new FileImages(Images.getImage((String)"icons/file.gif"));

    public void dispose() {
        this.fileImages.dispose();
    }

    public Image getImage(Object element) {
        String key = null;
        if (element instanceof WSProject || element instanceof WSProjectLink) {
            key = "icons/project.gif";
        } else if (element instanceof WSFolder || element instanceof WSFolderLink) {
            key = "icons/folder.gif";
        } else if (element instanceof WSFile || element instanceof WSFileLink) {
            WSResource resource = (WSResource)element;
            return this.fileImages.get(resource.getName());
        }
        if (key != null) {
            return Images.getImage((String)key);
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString r = new StyledString();
        r.append(((WSResource)element).getName());
        if (element instanceof WSLink) {
            WSLink link = (WSLink)element;
            if (link.getPath() == null || link.getPath().length() == 0) {
                r.append(String.format(" - %s", link.getProject()), StyledString.QUALIFIER_STYLER);
            } else {
                r.append(String.format(" - %s/%s", link.getProject(), link.getPath()), StyledString.QUALIFIER_STYLER);
            }
        }
        return r;
    }
}

