/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.progress.IProgressConstants;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.ContentProviderFactory;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.Preferences;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.ProgressMonitorJobsDialog;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class ProgressMonitorFocusJobDialog
extends ProgressMonitorJobsDialog {
    Job job;
    private boolean showDialog;
    private ProgressManager progressManager;

    public ProgressMonitorFocusJobDialog(Shell parentShell, IProgressService progressService, ProgressManager progressManager, ContentProviderFactory contentProviderFactory, FinishedJobs finishedJobs) {
        super(parentShell == null ? ProgressManagerUtil.getNonModalShell() : parentShell, progressService, progressManager, contentProviderFactory, finishedJobs);
        this.progressManager = progressManager;
        this.setShellStyle(ProgressMonitorFocusJobDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10 | 0x400);
        this.setCancelable(true);
        this.enableDetailsButton = true;
    }

    protected void cancelPressed() {
        this.job.cancel();
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.job.getName());
        shell.addTraverseListener(e -> {
            if (e.detail == 2) {
                this.cancelPressed();
                e.detail = 0;
                e.doit = true;
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button runInWorkspace = this.createButton(parent, 12, ProgressMessages.ProgressMonitorFocusJobDialog_RunInBackgroundButton, true);
        runInWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorFocusJobDialog.this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.FALSE);
                ProgressMonitorFocusJobDialog.this.finishedRun();
            }
        });
        runInWorkspace.setCursor(this.arrowCursor);
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.setCursor(this.arrowCursor);
        this.createDetailsButton(parent);
    }

    private IJobChangeListener createCloseListener() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (ProgressMonitorFocusJobDialog.this.getShell() == null) {
                    return;
                }
                UIJob closeJob = UIJob.create(ProgressMessages.ProgressMonitorFocusJobDialog_CLoseDialogJob, monitor -> {
                    Shell currentShell = ProgressMonitorFocusJobDialog.this.getShell();
                    if (currentShell == null || currentShell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    ProgressMonitorFocusJobDialog.this.finishedRun();
                    return Status.OK_STATUS;
                });
                closeJob.setSystem(true);
                closeJob.schedule();
            }
        };
    }

    private IProgressMonitor getBlockingProgressMonitor() {
        return new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                String finalName = name;
                int finalWork = totalWork;
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().beginTask(finalName, finalWork));
            }

            public void clearBlocked() {
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().clearBlocked());
            }

            public void done() {
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().done());
            }

            public void internalWorked(double work) {
                double finalWork = work;
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().internalWorked(finalWork));
            }

            public boolean isCanceled() {
                return ProgressMonitorFocusJobDialog.this.getProgressMonitor().isCanceled();
            }

            private void runAsync(Runnable runnable) {
                Display display;
                if (ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                    return;
                }
                Shell currentShell = ProgressMonitorFocusJobDialog.this.getShell();
                if (currentShell == null) {
                    display = Display.getDefault();
                } else {
                    if (currentShell.isDisposed()) {
                        return;
                    }
                    display = currentShell.getDisplay();
                }
                display.asyncExec(() -> {
                    if (ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                        return;
                    }
                    Shell shell = ProgressMonitorFocusJobDialog.this.getShell();
                    if (shell != null && shell.isDisposed()) {
                        return;
                    }
                    runnable.run();
                });
            }

            public void setBlocked(IStatus reason) {
                IStatus finalReason = reason;
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().setBlocked(finalReason));
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
                String finalName = name;
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().setTaskName(finalName));
            }

            public void subTask(String name) {
                String finalName = name;
                this.runAsync(() -> ProgressMonitorFocusJobDialog.this.getProgressMonitor().subTask(finalName));
            }

            public void worked(int work) {
                this.internalWorked(work);
            }
        };
    }

    public int open() {
        int result = super.open();
        IJobChangeListener listener = this.createCloseListener();
        this.job.addJobChangeListener(listener);
        if (this.job.getState() == 0) {
            this.job.removeJobChangeListener(listener);
            this.finishedRun();
            this.cleanUpFinishedJob();
        }
        return result;
    }

    public void show(Job jobToWatch, Shell originatingShell) {
        this.job = jobToWatch;
        this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.TRUE);
        this.progressManager.progressFor(this.job).addProgressListener(this.getBlockingProgressMonitor());
        this.setOpenOnRun(false);
        this.aboutToRun();
        final Object jobIsDone = new Object();
        JobChangeAdapter jobListener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = jobIsDone;
                synchronized (object) {
                    jobIsDone.notify();
                }
            }
        };
        this.job.addJobChangeListener((IJobChangeListener)jobListener);
        BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            try {
                Object object2 = jobIsDone;
                synchronized (object2) {
                    if (this.job.getState() != 0) {
                        jobIsDone.wait(ProgressManagerUtil.SHORT_OPERATION_TIME);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.job.removeJobChangeListener((IJobChangeListener)jobListener);
        UIJob openJob = UIJob.create(ProgressMessages.ProgressMonitorFocusJobDialog_UserDialogJob, m -> {
            if (this.job.getState() == 0) {
                this.finishedRun();
                this.cleanUpFinishedJob();
                return Status.CANCEL_STATUS;
            }
            if (!ProgressManagerUtil.safeToOpen(this, originatingShell)) {
                return Status.CANCEL_STATUS;
            }
            if (this.getParentShell() != null && this.getParentShell().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            this.open();
            return Status.OK_STATUS;
        });
        openJob.setSystem(true);
        openJob.schedule();
    }

    private void cleanUpFinishedJob() {
        this.progressManager.checkForStaleness(this.job);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        this.getProgressMonitor().setTaskName(this.progressManager.getJobInfo(this.job).getDisplayString());
        return area;
    }

    @Override
    protected void createExtendedDialogArea(Composite parent) {
        this.showDialog = Preferences.getBoolean("RUN_IN_BACKGROUND");
        final Button showUserDialogButton = new Button(parent, 32);
        showUserDialogButton.setText(ProgressMessages.WorkbenchPreference_RunInBackgroundButton);
        showUserDialogButton.setToolTipText(ProgressMessages.WorkbenchPreference_RunInBackgroundToolTip);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        showUserDialogButton.setLayoutData((Object)gd);
        showUserDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorFocusJobDialog.this.showDialog = showUserDialogButton.getSelection();
            }
        });
        super.createExtendedDialogArea(parent);
    }

    @Override
    public boolean close() {
        if (this.getReturnCode() != 1) {
            Preferences.set("RUN_IN_BACKGROUND", this.showDialog);
        }
        return super.close();
    }

    protected Display getDisplay() {
        return Services.getInstance().getDisplay();
    }
}

