/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ctx.filesystem.ui.Activator;
import org.eclipse.rcptt.ctx.filesystem.ui.FilesystemContentRootPathDialog;
import org.eclipse.rcptt.ctx.filesystem.ui.FilesystemContextContentProvider;
import org.eclipse.rcptt.ctx.filesystem.ui.FilesystemContextLabelProvider;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.AddFiles;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.AddFolder;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.FSAction;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.OpenFile;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.Remove;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.Rename;
import org.eclipse.rcptt.filesystem.FSCaptureParam;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.filesystem.FSResource;
import org.eclipse.rcptt.filesystem.FilesystemContext;
import org.eclipse.rcptt.filesystem.FilesystemFactory;
import org.eclipse.rcptt.filesystem.FilesystemPackage;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.commons.OneSelectionListener;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.DefaultTreeViewerEditStrategy;
import org.eclipse.rcptt.ui.utils.UIContentAdapter;
import org.eclipse.rcptt.util.FileSystemResolver;
import org.eclipse.rcptt.util.PrefixScheme;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FilesystemContextEditor
extends BaseContextEditor {
    private EditorHeader header;
    private TreeViewer viewer;
    private List<Button> buttons = new ArrayList<Button>();
    private FileSystemResolver currentResolver = null;
    private UpdateValueStrategy<String, String> rootStrategy = new UpdateValueStrategy<String, String>(){
        {
            this.setBeforeSetValidator((IValidator)new IValidator<String>(){

                public IStatus validate(String value) {
                    String path = value;
                    if (path == null || path.length() == 0) {
                        (this).FilesystemContextEditor.this.header.getRecordButton().setEnabled(false);
                        (this).FilesystemContextEditor.this.header.getReplayButton().setEnabled(false);
                        return ValidationStatus.warning((String)"No root path provided.");
                    }
                    (this).FilesystemContextEditor.this.header.getRecordButton().setEnabled(true);
                    (this).FilesystemContextEditor.this.header.getReplayButton().setEnabled(true);
                    return ValidationStatus.ok();
                }
            });
        }
    };
    private Remove removeAction;
    private OpenFile openFileAction;

    public FilesystemContext getContextElement() {
        try {
            return (FilesystemContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public EObject getCreateParam(AutLaunch launch) throws CoreException {
        String path = this.getContextElement().getPath();
        FileSystemResolver resolver = this.createResolver(launch);
        if (!resolver.isDirectory(path)) {
            FilesystemContentRootPathDialog dialog = new FilesystemContentRootPathDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), path, resolver);
            if (dialog.open() == 0) {
                this.getContextElement().setPath(dialog.getRootpath());
            } else {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        FSCaptureParam param = FilesystemFactory.eINSTANCE.createFSCaptureParam();
        param.setPath(this.getContextElement().getPath());
        param.setClear(this.getContextElement().isClear());
        return param;
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        this.header = header;
        if (this.getContextElement().getRoot() == null) {
            this.getContextElement().setRoot(FilesystemFactory.eINSTANCE.createFSFolder());
        }
        Section section = new SectionWithComposite("Folder", 322).create(parent, toolkit);
        Composite client = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 10).applyTo(client);
        this.createRootControls(toolkit, client);
        this.createOptionsControls(toolkit, client);
        this.createTree(toolkit, client);
        this.createButtons(toolkit, client);
        this.setSelection(null);
        return section;
    }

    private void createButtons(FormToolkit toolkit, Composite client) {
        Composite panel = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)panel);
        RowLayout layout = new RowLayout(512);
        layout.pack = false;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        panel.setLayout((Layout)layout);
        this.createButton(panel, toolkit, new AddFiles());
        this.createButton(panel, toolkit, new AddFolder());
        this.removeAction = new Remove();
        this.createButton(panel, toolkit, this.removeAction);
        this.openFileAction = new OpenFile();
        this.createButton(panel, toolkit, this.openFileAction);
        this.createButton(panel, toolkit, new Rename());
        this.setSelection(null);
    }

    private void createButton(Composite parent, FormToolkit toolkit, final FSAction action) {
        action.setViewer(this.viewer);
        Button button = toolkit.createButton(parent, action.getText(), 8);
        button.setData((Object)action);
        Image image = action.getImageDescriptor().createImage();
        button.addDisposeListener(ignored -> image.dispose());
        button.setImage(image);
        button.setToolTipText(action.getToolTipText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        this.buttons.add(button);
    }

    private void setSelection(FSResource[] selection) {
        for (Button button : this.buttons) {
            FSAction action = (FSAction)((Object)button.getData());
            action.setSelection(selection);
            button.setEnabled(action.isEnabled());
        }
    }

    private void createTree(FormToolkit toolkit, Composite client) {
        Tree tree = new Tree(client, 2050);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(100, 50).applyTo((Control)tree);
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new FilesystemContextLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new FilesystemContextContentProvider());
        this.viewer.setInput((Object)this.getContextElement());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)FilesystemContextEditor.this.viewer.getSelection();
                Object[] res = sel.toArray();
                FSResource[] resources = new FSResource[res.length];
                int i = 0;
                while (i < res.length) {
                    resources[i] = (FSResource)res[i];
                    ++i;
                }
                FilesystemContextEditor.this.setSelection(resources);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (FilesystemContextEditor.this.openFileAction.isEnabled()) {
                    FilesystemContextEditor.this.openFileAction.run();
                } else {
                    IStructuredSelection selection;
                    Object selectedNode;
                    TreeViewer viewer;
                    viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()));
                }
            }
        });
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new DefaultTreeViewerEditStrategy((ColumnViewer)this.viewer), (int)1);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree)});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TreeItem item = (TreeItem)element;
                FSResource res = (FSResource)item.getData();
                EObject parent = res.eContainer();
                Set<String> allNames = FilesystemContextEditor.this.getAllNames(parent);
                allNames.remove(res.getName());
                String newValue = (String)value;
                if (allNames.contains(newValue)) {
                    return;
                }
                if (newValue != null && !newValue.isEmpty() && !newValue.equals(res.getName())) {
                    res.setName(newValue);
                }
            }

            public Object getValue(Object element, String property) {
                return ((FSResource)element).getName();
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.viewer.setColumnProperties(new String[]{""});
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0 && FilesystemContextEditor.this.removeAction.isEnabled()) {
                    FilesystemContextEditor.this.removeAction.run();
                    e.doit = false;
                }
            }
        });
        UIContentAdapter adapter = new UIContentAdapter(){

            protected void changed(Notification notification) {
                if (FilesystemContextEditor.this.viewer.getControl().isDisposed()) {
                    return;
                }
                FilesystemContextEditor.this.viewer.refresh();
            }
        };
        this.getContextElement().eAdapters().add((Object)adapter);
    }

    private void createOptionsControls(FormToolkit toolkit, Composite client) {
        final Button clearCheckbox = toolkit.createButton(client, "Clear root folder before context application", 32);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)clearCheckbox);
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        IObservableValue clear = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)FilesystemPackage.Literals.FILESYSTEM_CONTEXT__CLEAR);
        final Binding binding = this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)clearCheckbox), clear, strategy, null);
        clearCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (clearCheckbox.getSelection() && !FilesystemContextEditor.this.isClearConfirmed()) {
                    clearCheckbox.setSelection(false);
                    return;
                }
                binding.updateTargetToModel();
            }
        });
    }

    private boolean isClearConfirmed() {
        String resolvedPath;
        String path = this.getContextElement().getPath();
        if (path == null || path.isEmpty()) {
            path = "selected root path";
        } else if (this.currentResolver != null && (resolvedPath = this.currentResolver.resolve(path)) != null) {
            path = resolvedPath;
        }
        return MessageDialog.openQuestion((Shell)this.viewer.getControl().getShell(), (String)"Confirm folder clear", (String)String.format("Enabling this option will cause a complete removal of %s during context apply. Do you want to enable it?", path));
    }

    private void createRootControls(FormToolkit toolkit, final Composite client) {
        Composite panel = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)panel);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(10, 10).applyTo(panel);
        Label rootLabel = toolkit.createLabel(panel, "Root path:");
        rootLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        rootLabel.setBackground(null);
        Text rootText = toolkit.createText(panel, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(1, -1).applyTo((Control)rootText);
        IObservableValue path = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)FilesystemPackage.Literals.FILESYSTEM_CONTEXT__PATH);
        Binding rootBinding = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)rootText), path, this.rootStrategy, this.rootStrategy);
        ControlDecorationSupport.create((ValidationStatusProvider)rootBinding, (int)16512, (Composite)panel, (ControlDecorationUpdater)new ControlDecorationUpdater(){

            protected void update(ControlDecoration decoration, IStatus status) {
                decoration.setMarginWidth(2);
                super.update(decoration, status);
            }
        });
        Button browseButton = toolkit.createButton(panel, "Browse...", 8);
        browseButton.addSelectionListener((SelectionListener)new OneSelectionListener(){

            public void selected(SelectionEvent e) {
                AutLaunch launch = LaunchUtils.selectAutLaunch((Shell)client.getShell());
                if (launch == null) {
                    return;
                }
                DirectoryDialog dialog = new DirectoryDialog(client.getShell());
                String result = dialog.open();
                if (result != null) {
                    FilesystemContextEditor.this.getContextElement().setPath(FilesystemContextEditor.this.makeRootPath(result, launch));
                }
            }
        });
    }

    private static String substituteAndCanonicalize(String value) {
        String result = value;
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false);
        }
        catch (CoreException e) {
            Activator.logErr(e, "Failed to substitute variables in %s", value);
        }
        try {
            result = new File(result).getCanonicalPath();
        }
        catch (IOException e) {
            Activator.logErr(e, "Failed to canonicalize %s", value);
        }
        return result;
    }

    private String makeRootPath(String path, AutLaunch launch) {
        String made = this.getResolvedPath(path, launch);
        if (made != null) {
            path = made;
        }
        return path;
    }

    private FileSystemResolver createResolver(AutLaunch launch) {
        FileSystemResolver resolver = new FileSystemResolver();
        ILaunchConfiguration config = launch.getAut().getConfig();
        if (config != null) {
            String location;
            try {
                location = config.getAttribute("location", null);
                if (location != null && location.length() > 0) {
                    resolver.register((FileSystemResolver.Scheme)new PrefixScheme("workspace://", FilesystemContextEditor.substituteAndCanonicalize(location)));
                }
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
            try {
                location = config.getAttribute("aut-location", null);
                if (location != null && location.length() > 0) {
                    resolver.register((FileSystemResolver.Scheme)new PrefixScheme("aut://", FilesystemContextEditor.substituteAndCanonicalize(location)));
                }
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("file://", null));
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("home://", new File(System.getProperty("user.home")).getAbsolutePath()));
        return resolver;
    }

    private String getResolvedPath(String path, AutLaunch launch) {
        this.currentResolver = this.createResolver(launch);
        return this.currentResolver.make(path);
    }

    private Set<String> getAllNames(EObject parent) {
        HashSet<String> allNames = new HashSet<String>();
        if (parent instanceof FSFolder) {
            EList folders = ((FSFolder)parent).getFolders();
            EList files = ((FSFolder)parent).getFiles();
            for (FSFile fsFile : files) {
                allNames.add(fsFile.getName());
            }
            for (FSFolder folder : folders) {
                allNames.add(folder.getName());
            }
        }
        return allNames;
    }
}

