/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.AsynchronousListOperation;
import org.eclipse.egit.ui.internal.dialogs.CancelableFuture;
import org.eclipse.egit.ui.internal.fetch.AbstractFetchFromHostPage;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class FetchGerritChangePage
extends AbstractFetchFromHostPage {
    private static final String GERRIT_CHANGE_REF_PREFIX = "refs/changes/";
    private static final Pattern GERRIT_FETCH_PATTERN = Pattern.compile("git fetch \"?(\\w+:[^\"\\s]+)\"? (refs/changes/\\d+/\\d+/\\d+) && git (\\w+(?:-\\w+)?(?: -b)?).* FETCH_HEAD");
    private static final Pattern GERRIT_URL_PATTERN = Pattern.compile("(?:https?://\\S+?/|/)?([1-9][0-9]*)(?:/([1-9][0-9]*)(?:/([1-9][0-9]*)(?:\\.\\.\\d+)?)?)?(?:/\\S*)?");
    private static final Pattern GERRIT_CHANGE_REF_PATTERN = Pattern.compile("refs/changes/(\\d\\d)/([1-9][0-9]*)(?:/([1-9][0-9]*)?)?");
    private static final Pattern DIGITS = Pattern.compile("\\d+(?:/\\d+)?");
    private static final String WILDCARD = ".*";
    private static final SimpleDateFormat SIMPLE_TIMESTAMP = new SimpleDateFormat("yyyyMMddHHmmss");

    public FetchGerritChangePage(Repository repository, String initialText) {
        super(repository, initialText, UIText.FetchGerritChangePage_ChangeLabel, UIText.FetchGerritChangePage_ChangeNameSingular, UIText.FetchGerritChangePage_ChangeNamePlural, true);
    }

    @Override
    Set<String> determineUris(Repository repo, String defaultUri) {
        HashSet<String> uris = new HashSet<String>();
        try {
            for (RemoteConfig rc : RemoteConfig.getAllRemoteConfigs((Config)repo.getConfig())) {
                if (!GerritUtil.isGerritFetch((RemoteConfig)rc)) continue;
                if (rc.getURIs().size() > 0) {
                    uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                }
                for (URIish u : rc.getPushURIs()) {
                    uris.add(u.toPrivateString());
                }
            }
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
            return Collections.emptySet();
        }
        return uris;
    }

    ChangeList createChangeList(Repository repo, String uri) {
        return new ChangeList(repo, uri);
    }

    static AbstractFetchFromHostPage.Change fromRef(String refName) {
        int changeNumber;
        Matcher m;
        block7: {
            block6: {
                block5: {
                    if (refName != null) break block5;
                    return null;
                }
                m = GERRIT_CHANGE_REF_PATTERN.matcher(refName);
                if (m.matches() && m.group(3) != null) break block6;
                return null;
            }
            Integer subdir = Integer.valueOf(m.group(1));
            changeNumber = Integer.parseInt(m.group(2));
            if (subdir == changeNumber % 100) break block7;
            return null;
        }
        try {
            Integer patchSetNumber = Integer.valueOf(m.group(3));
            return new GerritChange(refName, changeNumber, patchSetNumber);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    @Override
    AbstractFetchFromHostPage.Change changeFromRef(String refName) {
        return FetchGerritChangePage.fromRef(refName);
    }

    static AbstractFetchFromHostPage.Change fromString(String input) {
        if (input == null) {
            return null;
        }
        try {
            Matcher matcher = GERRIT_URL_PATTERN.matcher(input);
            if (matcher.matches()) {
                String first = matcher.group(1);
                String second = matcher.group(2);
                String third = matcher.group(3);
                if (second != null && !second.isEmpty()) {
                    int secondNum;
                    if (third != null && !third.isEmpty()) {
                        return new GerritChange(Integer.parseInt(second), Integer.parseInt(third));
                    }
                    if (input.startsWith("http")) {
                        return new GerritChange(Integer.parseInt(first), Integer.parseInt(second));
                    }
                    int firstNum = Integer.parseInt(first);
                    if (firstNum > (secondNum = Integer.parseInt(second))) {
                        return new GerritChange(firstNum, secondNum);
                    }
                    return new GerritChange(secondNum);
                }
                return new GerritChange(Integer.parseInt(first));
            }
            matcher = GERRIT_CHANGE_REF_PATTERN.matcher(input);
            if (matcher.matches()) {
                int firstNum = Integer.parseInt(matcher.group(2));
                String second = matcher.group(3);
                if (second != null) {
                    return new GerritChange(firstNum, Integer.parseInt(second));
                }
                return new GerritChange(firstNum);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    AbstractFetchFromHostPage.Change changeFromString(String input) {
        return FetchGerritChangePage.fromString(input);
    }

    @Override
    AbstractFetchFromHostPage.Defaults getDefaults(String initialText) {
        if (initialText == null) {
            return null;
        }
        String defaultUri = null;
        AbstractFetchFromHostPage.CheckoutMode defaultCommand = AbstractFetchFromHostPage.CheckoutMode.CREATE_BRANCH;
        AbstractFetchFromHostPage.Change defaultChange = null;
        Matcher matcher = GERRIT_FETCH_PATTERN.matcher(initialText);
        if (matcher.matches()) {
            defaultUri = matcher.group(1);
            defaultChange = this.changeFromRef(matcher.group(2));
            String cmd = matcher.group(3);
            if ("checkout".equals(cmd)) {
                defaultCommand = AbstractFetchFromHostPage.CheckoutMode.CHECKOUT_FETCH_HEAD;
            } else if ("cherry-pick".equals(cmd)) {
                defaultCommand = AbstractFetchFromHostPage.CheckoutMode.CHERRY_PICK;
            }
        } else {
            defaultChange = this.changeFromString(initialText.trim());
        }
        return new AbstractFetchFromHostPage.Defaults(defaultUri, defaultCommand, defaultChange);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Pattern getProposalPattern(String input) {
        AbstractFetchFromHostPage.Change change = this.changeFromString(input);
        long changeNumber = -1L;
        try {
            if (change == null) {
                Matcher matcher = DIGITS.matcher(input);
                if (matcher.find()) {
                    return Pattern.compile("refs/changes/(../)?" + matcher.group() + WILDCARD);
                }
                if (input.startsWith(GERRIT_CHANGE_REF_PREFIX)) return null;
                if (GERRIT_CHANGE_REF_PREFIX.startsWith(input)) {
                    return null;
                }
            } else {
                changeNumber = change.getChangeNumber();
            }
            if (changeNumber <= 0L) return UIUtils.createProposalPattern(input);
            return Pattern.compile("refs/changes/../" + changeNumber + WILDCARD);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return UIUtils.createProposalPattern(input);
    }

    private static class ChangeList
    extends AsynchronousListOperation<AbstractFetchFromHostPage.Change> {
        public ChangeList(Repository repository, String uriText) {
            super(repository, uriText);
        }

        @Override
        protected Collection<AbstractFetchFromHostPage.Change> convert(Collection<Ref> refs) {
            ArrayList<AbstractFetchFromHostPage.Change> changes = new ArrayList<AbstractFetchFromHostPage.Change>();
            for (Ref ref : refs) {
                AbstractFetchFromHostPage.Change change = FetchGerritChangePage.fromRef(ref.getName());
                if (change == null) continue;
                changes.add(change);
            }
            Collections.sort(changes, Collections.reverseOrder());
            return new LinkedHashSet<AbstractFetchFromHostPage.Change>(changes);
        }
    }

    static class GerritChange
    implements AbstractFetchFromHostPage.Change {
        private final String refName;
        private final long changeNumber;
        private final Integer patchSetNumber;

        public GerritChange(long changeNumber) {
            this(null, changeNumber, null);
        }

        public GerritChange(long changeNumber, int patchSetNumber) {
            this(null, changeNumber, patchSetNumber);
        }

        public GerritChange(String refName, long changeNumber, Integer patchSetNumber) {
            Object ref = refName;
            if (ref == null && patchSetNumber != null) {
                int subDir = (int)(changeNumber % 100L);
                ref = FetchGerritChangePage.GERRIT_CHANGE_REF_PREFIX + String.format("%02d", subDir) + "/" + changeNumber + "/" + String.valueOf(patchSetNumber);
            }
            this.refName = ref;
            this.changeNumber = changeNumber;
            this.patchSetNumber = patchSetNumber;
        }

        @Override
        public String getRefName() {
            return this.refName;
        }

        @Override
        public long getChangeNumber() {
            return this.changeNumber;
        }

        public Integer getPatchSetNumber() {
            return this.patchSetNumber;
        }

        public String toString() {
            return this.refName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbstractFetchFromHostPage.Change)) {
                return false;
            }
            return this.compareTo((AbstractFetchFromHostPage.Change)obj) == 0;
        }

        public int hashCode() {
            return Long.hashCode(this.changeNumber) * 31 + Objects.hash(this.patchSetNumber);
        }

        @Override
        public int compareTo(AbstractFetchFromHostPage.Change o) {
            int changeDiff = Long.compare(this.changeNumber, o.getChangeNumber());
            if (changeDiff == 0 && o instanceof GerritChange) {
                GerritChange other = (GerritChange)o;
                if (this.patchSetNumber == null) {
                    return other.getPatchSetNumber() != null ? -1 : 0;
                }
                if (other.getPatchSetNumber() == null) {
                    return 1;
                }
                changeDiff = this.patchSetNumber.compareTo(other.getPatchSetNumber());
            }
            return changeDiff;
        }

        @Override
        public IContentProposal getProposal() {
            String label = Long.toString(this.getChangeNumber()) + " - " + String.valueOf(this.getPatchSetNumber());
            String description = MessageFormat.format(UIText.FetchGerritChangePage_ContentAssistDescription, this.getPatchSetNumber().toString(), Long.toString(this.getChangeNumber()));
            return new ContentProposal(this.getRefName(), label, description, 0);
        }

        @Override
        public boolean isComplete() {
            return this.getPatchSetNumber() != null;
        }

        @Override
        public AbstractFetchFromHostPage.Change complete(CancelableFuture<Collection<AbstractFetchFromHostPage.Change>> list, String uri, IProgressMonitor monitor) {
            if (!this.isComplete()) {
                Collection<AbstractFetchFromHostPage.Change> changes;
                monitor.subTask(MessageFormat.format(UIText.AsynchronousRefProposalProvider_FetchingRemoteRefsMessage, uri));
                try {
                    changes = list.get();
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new OperationCanceledException();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                AbstractFetchFromHostPage.Change highest = this.findHighestPatchSet(changes, this.getChangeNumber());
                if (highest != null) {
                    return highest;
                }
            }
            return this;
        }

        @Override
        public AbstractFetchFromHostPage.Change complete(Collection<AbstractFetchFromHostPage.Change> changes) {
            if (this.isComplete()) {
                return null;
            }
            return this.findHighestPatchSet(changes, this.getChangeNumber());
        }

        private AbstractFetchFromHostPage.Change findHighestPatchSet(Collection<AbstractFetchFromHostPage.Change> changes, long chgNumber) {
            if (changes == null) {
                return null;
            }
            for (AbstractFetchFromHostPage.Change fromGerrit : changes) {
                long num = fromGerrit.getChangeNumber();
                if (num < chgNumber) {
                    return null;
                }
                if (chgNumber != num) continue;
                return fromGerrit;
            }
            return null;
        }

        @Override
        public String getBranchSuggestion() {
            Object ps = this.getPatchSetNumber();
            if (ps == null) {
                ps = SIMPLE_TIMESTAMP.format(new Date());
            }
            return MessageFormat.format(UIText.FetchGerritChangePage_SuggestedRefNamePattern, Long.toString(this.getChangeNumber()), ps);
        }

        @Override
        public String completeId() {
            if (this.isComplete()) {
                return Long.toString(this.getChangeNumber()) + "/" + String.valueOf(this.getPatchSetNumber());
            }
            return Long.toString(this.getChangeNumber());
        }
    }
}

