/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class ComboLabelingSupport {
    private final Combo combo;
    private List<? extends IContentProposal> proposals;

    public ComboLabelingSupport(final Combo combo, final SelectionListener selectionListener) {
        this.combo = combo;
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = combo.getSelectionIndex();
                if (i != -1 && i < ComboLabelingSupport.this.proposals.size()) {
                    combo.setText(ComboLabelingSupport.this.proposals.get(i).getContent());
                    if (selectionListener != null) {
                        selectionListener.widgetSelected(e);
                    }
                }
            }
        });
        this.setProposals(Collections.emptyList());
    }

    public void setProposals(List<? extends IContentProposal> proposals) {
        this.proposals = proposals;
        String[] itemsLabels = new String[proposals.size()];
        int i = 0;
        for (IContentProposal iContentProposal : proposals) {
            itemsLabels[i++] = iContentProposal.getLabel();
        }
        this.combo.setItems(itemsLabels);
    }

    public String getContent() {
        String text = this.combo.getText();
        for (IContentProposal iContentProposal : this.proposals) {
            if (!text.equals(iContentProposal.getLabel())) continue;
            return iContentProposal.getContent();
        }
        return text;
    }
}

