/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.TestEngineManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.TestEngineLaunchConfigManager;
import org.eclipse.rcptt.ui.launching.ITestEngineLaunchConfig;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TestEnginesLaunchTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_ID = "org.eclipse.rcptt.ui.launching.TestEnginesTab";
    private Map<String, Button> testEngineButtons;
    private List<TestEngineManager.TestEngineExtension> testEngines = TestEngineManager.getInstance().getEngines();
    private List<TestEngineLaunchConfigManager.TestEngineLaunchConfig> launchConfigs = TestEngineLaunchConfigManager.getInstance().getLaunchConfigs();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)composite);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TestEnginesLaunchTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.testEngineButtons = new HashMap<String, Button>();
        for (TestEngineManager.TestEngineExtension engine : this.testEngines) {
            String id = engine.getId();
            String name = engine.getName();
            Group group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setText(name);
            group.setFont(parent.getFont());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            group.setLayoutData((Object)gd);
            Button engineButton = new Button((Composite)group, 32);
            engineButton.setText(MessageFormat.format((String)Messages.TestEnginesLaunchTab_EngineButtonName, (Object[])new Object[]{name}));
            engineButton.addListener(13, listener);
            this.testEngineButtons.put(id, engineButton);
            ITestEngineLaunchConfig launchConfig = this.getLaunchConfig(id);
            if (launchConfig == null) continue;
            launchConfig.createControl((Composite)group, listener);
        }
    }

    private ITestEngineLaunchConfig getLaunchConfig(String id) {
        for (TestEngineLaunchConfigManager.TestEngineLaunchConfig config : this.launchConfigs) {
            if (!id.equals(config.getId())) continue;
            return config.getConfig();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (TestEngineLaunchConfigManager.TestEngineLaunchConfig config : this.launchConfigs) {
            config.getConfig().setDefaults(configuration);
        }
        configuration.setAttribute("org.eclipse.rcptt.launching.ATTR_TEST_ENGINES", new HashMap());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (TestEngineLaunchConfigManager.TestEngineLaunchConfig config : this.launchConfigs) {
            config.getConfig().initializeFrom(configuration);
        }
        Map testEngines = Collections.emptyMap();
        try {
            testEngines = configuration.getAttribute("org.eclipse.rcptt.launching.ATTR_TEST_ENGINES", testEngines);
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log((Throwable)e);
        }
        this.setTestEnginesStatuses(testEngines);
    }

    private void setTestEnginesStatuses(Map<String, String> statuses) {
        Iterator<Map.Entry<String, Button>> iterator = this.testEngineButtons.entrySet().iterator();
        while (iterator.hasNext()) {
            String id;
            String enabled;
            Map.Entry<String, Button> button;
            button.getValue().setSelection((enabled = statuses.get(id = (button = iterator.next()).getKey())) != null && enabled.equals("true"));
        }
    }

    private Map<String, String> getTestEnginesStatuses() {
        HashMap<String, String> testEngines = new HashMap<String, String>();
        for (Map.Entry<String, Button> button : this.testEngineButtons.entrySet()) {
            String id = button.getKey();
            String enabled = String.valueOf(button.getValue().getSelection());
            testEngines.put(id, enabled);
        }
        return testEngines;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (TestEngineLaunchConfigManager.TestEngineLaunchConfig config : this.launchConfigs) {
            config.getConfig().performApply(configuration);
        }
        Map<String, String> testEngines = this.getTestEnginesStatuses();
        configuration.setAttribute("org.eclipse.rcptt.launching.ATTR_TEST_ENGINES", testEngines);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String message = this.validatePage();
        this.setMessage(null);
        this.setErrorMessage(message);
        this.validatePage();
        return this.getErrorMessage() == null;
    }

    private String validatePage() {
        Iterator<TestEngineLaunchConfigManager.TestEngineLaunchConfig> iterator = this.launchConfigs.iterator();
        if (iterator.hasNext()) {
            TestEngineLaunchConfigManager.TestEngineLaunchConfig config = iterator.next();
            return config.getConfig().validatePage();
        }
        return null;
    }

    public String getName() {
        return Messages.TestEnginesLaunchTab_Name;
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return Images.getImage("icons/releng_gears.gif");
    }
}

