/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.debug;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ToggleBreakpointEnablementAction
extends Action {
    private IVerticalRulerInfo ruler;
    private SourceViewer viewer;
    private IBreakpoint breakpoint;

    public ToggleBreakpointEnablementAction(SourceViewer viewer, IVerticalRulerInfo info) {
        this.viewer = viewer;
        this.ruler = info;
    }

    public void run() {
        if (this.breakpoint != null) {
            try {
                this.breakpoint.setEnabled(!this.breakpoint.isEnabled());
            }
            catch (CoreException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    public void update() {
        block5: {
            this.breakpoint = this.getBreakpoint();
            this.setEnabled(this.breakpoint != null);
            if (this.breakpoint != null) {
                try {
                    if (this.breakpoint.isEnabled()) {
                        this.setText("&Disable Breakpoint");
                        break block5;
                    }
                    this.setText("&Enable Breakpoint");
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            } else {
                this.setText("Toggle Breakpoint Enablement");
            }
        }
    }

    private IBreakpoint getBreakpoint() {
        IAnnotationModel annotationModel = this.viewer.getAnnotationModel();
        IDocument document = this.viewer.getDocument();
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof SimpleMarkerAnnotation)) continue;
            SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
            IMarker marker = markerAnnotation.getMarker();
            try {
                IBreakpoint breakpoint;
                Position position;
                int line;
                if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != this.ruler.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                return breakpoint;
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }
}

