/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.UtilMessages;

public class VMUtil {
    private static final Map<String, Double> JAVA_VERSION_OF_EE = Arrays.stream(VMUtil.getExecutionEnvironments()).collect(Collectors.toMap(IExecutionEnvironment::getId, VMUtil::getJavaTargetVersion));
    public static final Comparator<String> ASCENDING_EE_JAVA_VERSION = Comparator.comparingDouble(ee -> JAVA_VERSION_OF_EE.getOrDefault(ee, 0.0)).thenComparing(Comparator.naturalOrder());

    public static Stream<IVMInstall> getAllVMInstances() {
        return Arrays.stream(JavaRuntime.getVMInstallTypes()).flatMap(type -> Arrays.stream(type.getVMInstalls()));
    }

    public static String[] getVMInstallNames() {
        return (String[])VMUtil.getAllVMInstances().map(IVMInstall::getName).toArray(String[]::new);
    }

    public static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return "";
    }

    public static String getDefaultVMInstallLocation() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getInstallLocation().getAbsolutePath();
        }
        return null;
    }

    public static IVMInstall getVMInstall(String name) {
        Optional<IVMInstall> install;
        if (name != null && (install = VMUtil.getAllVMInstances().filter(i -> i.getName().equals(name)).findFirst()).isPresent()) {
            return install.get();
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IExecutionEnvironment[] getExecutionEnvironments() {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return manager.getExecutionEnvironments();
    }

    public static IExecutionEnvironment getExecutionEnvironment(String id) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return manager.getEnvironment(id);
    }

    public static String getVMInstallName(IExecutionEnvironment ee) throws CoreException {
        IPath containerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
        IVMInstall vmi = JavaRuntime.getVMInstall((IPath)containerPath);
        if (vmi == null) {
            throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.VMHelper_noJreForExecEnv, (Object)ee.getId())));
        }
        return vmi.getName();
    }

    public static double getJavaTargetVersion(IExecutionEnvironment ee) {
        double d;
        Object target;
        Properties properties = ee.getProfileProperties();
        Object object = target = properties != null ? properties.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") : null;
        if (target instanceof String) {
            String version = (String)target;
            d = Double.parseDouble(version);
        } else {
            d = 0.0;
        }
        return d;
    }
}

