/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.rcptt.tesla.recording.core.swt.WidgetDetailsProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SWTRecordingHelper
extends BasicRecordingHelper<SWTUIElement> {
    private SWTUIPlayer player;
    private SWTWidgetLocator locator = null;
    private static SWTRecordingHelper mapper;

    public static synchronized SWTRecordingHelper getHelper() {
        if (mapper == null) {
            mapper = new SWTRecordingHelper();
        }
        return mapper;
    }

    public synchronized SWTUIPlayer getPlayer() {
        if (this.player == null) {
            this.player = SWTUIPlayer.getPlayer((Display)PlatformUI.getWorkbench().getDisplay());
        }
        return this.player;
    }

    public synchronized SWTWidgetLocator getLocator() {
        if (this.locator == null) {
            this.locator = new SWTWidgetLocator(this.getPlayer());
            this.locator.initialize(TeslaRecorder.getInstance());
        }
        return this.locator;
    }

    public void clearAllWithParent(SWTUIElement swtuiElement) {
        HashSet keySet = new HashSet(this.elements.keySet());
        for (SWTUIElement e : keySet) {
            List list;
            if (e.unwrap() != null && !e.unwrap().isDisposed() && !e.unwrap().getDisplay().equals(Display.getCurrent()) || !(list = this.getPlayer().getParentsList(e)).contains(swtuiElement)) continue;
            this.elements.remove(e);
        }
    }

    public synchronized void cleanDisposed() {
        HashSet keySet = new HashSet(this.elements.keySet());
        for (SWTUIElement swtuiElement : keySet) {
            if (!swtuiElement.isDisposed()) continue;
            this.remove(swtuiElement);
            this.clearAllWithParent(swtuiElement);
        }
    }

    @Override
    public PropertyNodeList getNodeProperties(Element element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        SWTUIElement swtUiElement = (SWTUIElement)this.findByElement(element);
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"widget.properties", (String)("fill list of extra properties for element: " + swtUiElement.getClassName() + (String)(nodePath != null && nodePath.length() > 0 ? " with prefix: " + nodePath : "")));
        }
        if (swtUiElement != null) {
            return SWTModelMapper.getPropertyNodes((SWTUIElement)swtUiElement, (String)nodePath);
        }
        return null;
    }

    @Override
    public String getWidgetDetails(Element element) {
        SWTUIElement swtUiElement = (SWTUIElement)this.findByElement(element);
        if (swtUiElement != null) {
            Widget widget = swtUiElement.unwrap();
            return new WidgetDetailsProvider().getDetails(widget, this.getPlayer());
        }
        return null;
    }
}

