/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.rcptt.tesla.core.ui.DiagramConnection;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.core.ui.WithImage;
import org.eclipse.rcptt.tesla.gef.GefUtils;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.swt.reflection.EMFMembersHelper;
import org.eclipse.rcptt.tesla.swt.reflection.JavaMembersHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class GefModelMapper {
    public static Widget map(EditPart part, SWTUIPlayer player) {
        Object model;
        DiagramItem item = GefModelMapper.basicMap(part);
        if (part instanceof AbstractConnectionEditPart) {
            GefModelMapper.fillConnectionProperies((AbstractConnectionEditPart)part, (DiagramConnection)item, player);
        }
        if ((model = GefModelMapper.getModel(part)) != null) {
            EMFMembersHelper.fillProperties((Object)model, (EList)item.getModelPropertyNodes());
        }
        return item;
    }

    public static DiagramItem basicMap(EditPart part) {
        Object item = part instanceof AbstractConnectionEditPart ? UiFactory.eINSTANCE.createDiagramConnection() : UiFactory.eINSTANCE.createDiagramItem();
        if (part.getViewer().getSelectedEditParts().contains(part)) {
            item.setSelected(true);
        } else {
            item.setSelected(false);
        }
        org.eclipse.swt.graphics.Rectangle bounds = GefModelMapper.getBounds(part);
        if (bounds != null) {
            item.setX(bounds.x);
            item.setY(bounds.y);
            item.setWidth(bounds.width);
            item.setHeight(bounds.height);
            if (part instanceof GraphicalEditPart) {
                item.setBackgroundColor(SWTModelMapper.makeColor((Color)((GraphicalEditPart)part).getFigure().getBackgroundColor()));
                item.setForegroundColor(SWTModelMapper.makeColor((Color)((GraphicalEditPart)part).getFigure().getForegroundColor()));
            }
            item.setClassName(part.getClass().getName());
            item.setItemAddress(GefUtils.getAddress(part).toString());
        }
        List children = part.getChildren();
        int count = 0;
        for (Object object : children) {
            IFigure figure;
            if (!(object instanceof GraphicalEditPart) || !(figure = ((GraphicalEditPart)object).getFigure()).isShowing()) continue;
            ++count;
        }
        String partText = GefModelMapper.getText(part, TextFlow.class, Label.class);
        item.setText(partText);
        item.setChildrenCount(count);
        GefModelMapper.addAdvancedProperies(part, (Widget)item);
        return item;
    }

    public static DiagramItem figureMap(IFigure figure) {
        DiagramItem item = UiFactory.eINSTANCE.createDiagramItem();
        if (figure instanceof Label) {
            SWTModelMapper.fillImage((WithImage)item, (Image)((Label)figure).getIcon());
        }
        item.setText(GefModelMapper.getText(figure));
        item.setTooltip(GefModelMapper.getText(figure.getToolTip()));
        item.setClassName(figure.getClass().getName());
        item.setChildrenCount(figure.getChildren().size());
        Rectangle bounds = figure.getBounds();
        item.setX(bounds.x);
        item.setY(bounds.y);
        item.setWidth(bounds.width);
        item.setHeight(bounds.height);
        item.setBackgroundColor(SWTModelMapper.makeColor((Color)figure.getBackgroundColor()));
        item.setForegroundColor(SWTModelMapper.makeColor((Color)figure.getForegroundColor()));
        GefModelMapper.addAdvancedProperies(figure, (Widget)item);
        return item;
    }

    private static Object getModel(EditPart part) {
        if (part instanceof GraphicalEditPart) {
            GraphicalEditPart gpart = (GraphicalEditPart)part;
            Object model = gpart.getModel();
            if (model instanceof EObject) {
                return model;
            }
            if (model instanceof EObjectObservableValue) {
                return ((EObjectObservableValue)model).getObserved();
            }
        }
        return null;
    }

    private static void addAdvancedProperies(Object object, Widget widget) {
        try {
            JavaMembersHelper.fillProperties((Object)object, (EList)widget.getPropertyNodes());
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
    }

    public static PropertyNodeList getPropertyNodes(EditPart part, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList;
        Object model = GefModelMapper.getModel(part);
        if (model != null && EMFMembersHelper.fillProperties((Object)model, (String)nodePath, (EList)(propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList()).getPropertyNodes())) {
            return propertyNodeList;
        }
        propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList();
        if (JavaMembersHelper.fillProperties((Object)part, (String)nodePath, (EList)propertyNodeList.getPropertyNodes())) {
            return propertyNodeList;
        }
        return GefModelMapper.getAdvancedPropertyNodes(part, nodePath);
    }

    public static PropertyNodeList getPropertyNodes(IFigure figure, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList();
        if (JavaMembersHelper.fillProperties((Object)figure, (String)nodePath, (EList)propertyNodeList.getPropertyNodes())) {
            return propertyNodeList;
        }
        return GefModelMapper.getAdvancedPropertyNodes(figure, nodePath);
    }

    public static PropertyNodeList getAdvancedPropertyNodes(Object object, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList();
        if (JavaMembersHelper.fillProperties((Object)object, (String)nodePath, (EList)propertyNodeList.getPropertyNodes())) {
            return propertyNodeList;
        }
        return null;
    }

    public static String getPropertyValue(EditPart part, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object model = GefModelMapper.getModel(part);
        String value = null;
        if (model != null) {
            value = EMFMembersHelper.getPropertyValue((Object)model, (String)nodePath);
        }
        if (value == null) {
            return GefModelMapper.getAdvancedPropertyValue(part, nodePath);
        }
        return value;
    }

    public static String getPropertyValue(IFigure figure, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return JavaMembersHelper.getPropertyValue((Object)figure, (String)nodePath);
    }

    public static String getAdvancedPropertyValue(Object object, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return JavaMembersHelper.getPropertyValue((Object)object, (String)nodePath);
    }

    private static void fillConnectionProperies(AbstractConnectionEditPart connectionPart, DiagramConnection connectionItem, SWTUIPlayer player) {
        DiagramItem source = GefModelMapper.basicMap(connectionPart.getSource());
        connectionItem.setSource(source);
        DiagramItem target = GefModelMapper.basicMap(connectionPart.getTarget());
        connectionItem.setTarget(target);
    }

    public static String getText(EditPart part, Class<?> ... classes) {
        StringBuilder builder = new StringBuilder();
        if (part instanceof GraphicalEditPart) {
            List list = part.getChildren();
            ArrayList<IFigure> skips = new ArrayList<IFigure>();
            for (Object cPart : list) {
                if (!(cPart instanceof GraphicalEditPart)) continue;
                skips.add(((GraphicalEditPart)cPart).getFigure());
            }
            GefModelMapper.fillFigureText(((GraphicalEditPart)part).getFigure(), builder, skips);
            block1: for (Object cPart : list) {
                IFigure figure;
                if (!(cPart instanceof GraphicalEditPart) || !(figure = ((GraphicalEditPart)cPart).getFigure()).isVisible()) continue;
                Class<?>[] classArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cl = classArray[n2];
                    if (cl.isInstance(figure)) {
                        GefModelMapper.fillFigureText(figure, builder, null);
                        continue block1;
                    }
                    ++n2;
                }
            }
        }
        return SWTModelMapper.unify((String)builder.toString().trim());
    }

    public static String getText(IFigure figure) {
        if (figure == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        GefModelMapper.fillFigureText(figure, builder, new ArrayList<IFigure>());
        return SWTModelMapper.unify((String)builder.toString().trim());
    }

    private static void fillFigureText(IFigure figure, StringBuilder builder, List<IFigure> skips) {
        if (figure.isVisible() && (skips == null || !skips.contains(figure))) {
            if (figure instanceof TextFlow) {
                builder.append(((TextFlow)figure).getText());
            }
            if (figure instanceof Label) {
                String labelText = ((Label)figure).getText();
                builder.append(labelText);
            }
            List list = figure.getChildren();
            boolean labelUsed = false;
            for (Object object : list) {
                int cur = builder.length();
                GefModelMapper.fillFigureText((IFigure)object, builder, skips);
                if (!(object instanceof Label)) continue;
                if (cur != builder.length() && !labelUsed) {
                    labelUsed = true;
                    continue;
                }
                builder.setLength(cur);
            }
        }
    }

    public static org.eclipse.swt.graphics.Rectangle getBounds(EditPart part) {
        if (part instanceof GraphicalEditPart) {
            Rectangle bounds = ((GraphicalEditPart)part).getFigure().getBounds();
            return new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        return null;
    }
}

