/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UnmergedBranchDialog
extends MessageDialog {
    private final List<Ref> refs;

    public UnmergedBranchDialog(Shell parentShell, List<Ref> refs) {
        super(parentShell, UIText.UnmergedBranchDialog_Title, null, UIText.UnmergedBranchDialog_Message, 3, new String[]{UIText.UnmergedBranchDialog_deleteButtonLabel, IDialogConstants.CANCEL_LABEL}, 0);
        this.refs = new ArrayList<Ref>(refs);
        Collections.sort(this.refs, CommonUtils.REF_ASCENDING_COMPARATOR);
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new FillLayout());
        TableViewer branchesList = new TableViewer(area);
        branchesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        branchesList.setLabelProvider((IBaseLabelProvider)new GitLabelProvider());
        branchesList.setInput(this.refs);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = Math.min(20, this.refs.size() + 1) * branchesList.getTable().getItemHeight();
        area.setLayoutData((Object)layoutData);
        return area;
    }
}

