/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.components.BranchNameNormalizer;
import org.eclipse.egit.ui.internal.credentials.SignatureUtils;
import org.eclipse.egit.ui.internal.dialogs.CommitCombo;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Signer;
import org.eclipse.jgit.lib.Signers;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class CreateTagDialog
extends TitleAreaDialog {
    private static final int MAX_COMMIT_COUNT = 1000;
    private static final int CLEAR_ID = 22;
    private static final int CREATE_AND_START_PUSH_ID = 23;
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^[\\h\\v]+");
    private String tagName;
    private String tagMessage;
    private ObjectId tagCommit;
    private boolean shouldStartPushWizard = false;
    private boolean overwriteTag;
    private boolean annotated;
    private TagWrapper existingTag;
    private Repository repo;
    private Text tagNameText;
    private SpellcheckableMessageArea tagMessageText;
    private Button overwriteButton;
    private Button signButton;
    private boolean signExplicit;
    private boolean signAll;
    private boolean signAnnotated;
    private boolean signUser;
    private TableViewer tagViewer;
    private CommitCombo commitCombo;
    private Pattern tagNamePattern;
    private final String branchName;
    private final ObjectId commitId;
    private final IInputValidator tagNameValidator;
    private final RevWalk rw;

    public CreateTagDialog(Shell parent, String branchName, Repository repo) {
        super(parent);
        this.tagNameValidator = ValidationUtils.getRefNameInputValidator(repo, "refs/tags/", false);
        this.branchName = branchName;
        this.commitId = null;
        this.repo = repo;
        this.rw = new RevWalk(repo);
        this.setHelpAvailable(false);
    }

    public CreateTagDialog(Shell parent, ObjectId commitId, Repository repo) {
        super(parent);
        this.tagNameValidator = ValidationUtils.getRefNameInputValidator(repo, "refs/tags/", false);
        this.branchName = null;
        this.commitId = commitId;
        this.repo = repo;
        this.rw = new RevWalk(repo);
        this.setHelpAvailable(false);
    }

    public ObjectId getTagCommit() {
        return this.tagCommit;
    }

    public String getTagMessage() {
        return this.tagMessage;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean shouldOverWriteTag() {
        return this.overwriteTag;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    @Nullable
    public Boolean shouldSign() {
        if (this.signButton == null) {
            return Boolean.FALSE;
        }
        return this.signExplicit ? Boolean.valueOf(this.signUser) : null;
    }

    public boolean shouldStartPushWizard() {
        return this.shouldStartPushWizard;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.CreateTagDialog_NewTag);
    }

    private String getTitle() {
        String title = "";
        if (this.branchName != null) {
            title = NLS.bind((String)UIText.CreateTagDialog_questionNewTagTitle, (Object)this.branchName);
        } else if (this.commitId != null) {
            title = NLS.bind((String)UIText.CreateTagDialog_CreateTagOnCommitTitle, (Object)CompareUtils.truncatedRevision(this.commitId.getName()));
        }
        return title;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        parent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button clearButton = this.createButton(parent, 22, UIText.CreateTagDialog_clearButton, false);
        clearButton.setToolTipText(UIText.CreateTagDialog_clearButtonTooltip);
        this.setButtonLayoutData(clearButton);
        Composite margin = new Composite(parent, 0);
        margin.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button createTagAndStartPushButton = this.createButton(parent, 23, UIText.CreateTagDialog_CreateTagAndStartPushButton, false);
        createTagAndStartPushButton.setToolTipText(UIText.CreateTagDialog_CreateTagAndStartPushToolTip);
        this.setButtonLayoutData(createTagAndStartPushButton);
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.CreateTagDialog_CreateTagButton);
        this.getButton(0).setToolTipText(UIText.CreateTagDialog_tagMessageToolTip);
        this.validateInput();
    }

    public void create() {
        super.create();
        Job job = new Job(UIText.CreateTagDialog_GetTagJobName){

            public boolean belongsTo(Object family) {
                if (JobFamilies.FILL_TAG_LIST.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final List<Object> tags = CreateTagDialog.this.getRevTags();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).CreateTagDialog.this.tagViewer.getTable().isDisposed()) {
                                (this).CreateTagDialog.this.tagViewer.setInput((Object)tags);
                                (this).CreateTagDialog.this.tagViewer.getTable().setEnabled(true);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    CreateTagDialog.this.setErrorMessage(UIText.CreateTagDialog_ExceptionRetrievingTagsMessage);
                    return Activator.createErrorStatus(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public boolean close() {
        this.rw.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(this.getTitle());
        this.setMessage(UIText.CreateTagDialog_Message);
        Composite composite = (Composite)super.createDialogArea(parent);
        SashForm mainForm = new SashForm(composite, 260);
        mainForm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createLeftSection(mainForm);
        this.createExistingTagsSection((Composite)mainForm);
        mainForm.setWeights(new int[]{70, 30});
        CreateTagDialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 22) {
            this.tagNameText.setText("");
            this.tagMessageText.setText("");
            if (this.commitCombo != null) {
                this.commitCombo.clearSelection();
            }
            this.tagMessageText.getTextWidget().setEditable(true);
            this.overwriteButton.setEnabled(false);
            this.overwriteButton.setSelection(false);
        } else if (buttonId == 0 || buttonId == 23) {
            this.shouldStartPushWizard = buttonId == 23;
            this.tagName = this.tagNameText.getText();
            if (this.commitCombo != null) {
                this.tagCommit = this.commitCombo.getValue();
            }
            this.tagMessage = this.tagMessageText.getCommitMessage();
            if (this.tagMessage != null) {
                this.tagMessage = LEADING_WHITESPACE.matcher(this.tagMessage).replaceFirst("");
            }
            this.overwriteTag = this.overwriteButton.getSelection();
            this.annotated = !this.tagMessageText.getCommitMessage().isEmpty();
            this.signUser = this.signButton != null && this.signButton.getSelection();
            this.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void createLeftSection(SashForm mainForm) {
        Composite left = new Composite((Composite)mainForm, 16);
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(10, 5).create());
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label label = new Label(left, 64);
        label.setText(UIText.CreateTagDialog_tagName);
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(150);
        label.setLayoutData((Object)data);
        label.setFont(left.getFont());
        this.tagNameText = new Text(left, 2436);
        this.tagNameText.setLayoutData((Object)new GridData(768));
        this.tagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tagNameValue = CreateTagDialog.this.tagNameText.getText();
                CreateTagDialog.this.tagNamePattern = Pattern.compile(Pattern.quote(tagNameValue), 2);
                CreateTagDialog.this.tagViewer.refresh();
                if (CreateTagDialog.this.existingTag == null || !tagNameValue.equals(CreateTagDialog.this.existingTag.getName())) {
                    CreateTagDialog.this.setExistingTagFromText(tagNameValue);
                }
                CreateTagDialog.this.validateInput();
            }
        });
        BranchNameNormalizer normalizer = new BranchNameNormalizer(this.tagNameText);
        normalizer.setVisible(false);
        new Label(left, 64).setText(UIText.CreateTagDialog_tagMessage);
        this.tagMessageText = new SpellcheckableMessageArea(left, this.tagMessage, 2048);
        CommitConfig config = (CommitConfig)this.repo.getConfig().get(CommitConfig.KEY);
        this.tagMessageText.setCleanupMode(config.resolve(CommitConfig.CleanupMode.DEFAULT, true), config.getCommentChar());
        Point size = this.tagMessageText.getTextWidget().getSize();
        this.tagMessageText.setLayoutData(GridDataFactory.fillDefaults().hint(size).grab(true, true).create());
        this.tagMessageText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Button button;
                if (UIUtils.isSubmitKeyEvent(e) && (button = CreateTagDialog.this.getButton(0)) != null && button.isEnabled()) {
                    CreateTagDialog.this.buttonPressed(0);
                }
            }
        });
        this.tagMessageText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTagDialog.this.validateInput();
                if (CreateTagDialog.this.signButton != null && !CreateTagDialog.this.signExplicit && !CreateTagDialog.this.signAll) {
                    String message = CreateTagDialog.this.tagMessageText.getText();
                    CreateTagDialog.this.signButton.setSelection(!message.isEmpty() && CreateTagDialog.this.signAnnotated);
                }
            }
        });
        this.overwriteButton = new Button(left, 32);
        this.overwriteButton.setEnabled(false);
        this.overwriteButton.setText(UIText.CreateTagDialog_overwriteTag);
        this.overwriteButton.setToolTipText(UIText.CreateTagDialog_overwriteTagToolTip);
        this.overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateTagDialog.this.validateInput();
            }
        });
        Repository db = this.repo;
        final File gpg = GitSettings.getGpgExecutable();
        GpgConfig gpgConfig = new GpgConfig((Config)db.getConfig()){

            public String getProgram() {
                return gpg != null ? gpg.getAbsolutePath() : super.getProgram();
            }
        };
        Signer signer = Signers.get((GpgConfig.GpgFormat)gpgConfig.getKeyFormat());
        if (signer != null) {
            PersonIdent tagger = new PersonIdent(db);
            if (SignatureUtils.checkSigningKey(db, signer, gpgConfig, tagger)) {
                this.signAll = gpgConfig.isSignAllTags();
                this.signAnnotated = gpgConfig.isSignAnnotated();
                this.signButton = new Button(left, 32);
                this.signButton.setText(UIText.CreateTagDialog_signTag);
                this.signButton.setToolTipText(UIText.CreateTagDialog_signTagToolTip);
                this.signButton.setSelection(this.signAll);
                this.signButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        super.widgetSelected(e);
                        CreateTagDialog.this.signExplicit = true;
                    }
                });
            } else {
                String signingKey = gpgConfig.getSigningKey();
                if (!StringUtils.isEmptyOrNull((String)signingKey)) {
                    CLabel warning = new CLabel(left, 64);
                    warning.setText(MessageFormat.format(UIText.CreateTagDialog_noSigningKey, signingKey));
                    warning.setToolTipText(UIText.CreateTagDialog_noSigningKeyToolTip);
                    warning.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
                }
            }
        }
        this.createAdvancedSection(left);
    }

    private void createAdvancedSection(final Composite composite) {
        if (this.commitId != null) {
            return;
        }
        ExpandableComposite advanced = new ExpandableComposite(composite, 20);
        advanced.setText(UIText.CreateTagDialog_advanced);
        advanced.setToolTipText(UIText.CreateTagDialog_advancedToolTip);
        advanced.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite advancedComposite = new Composite((Composite)advanced, 64);
        advancedComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        advancedComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label advancedLabel = new Label(advancedComposite, 64);
        advancedLabel.setText(UIText.CreateTagDialog_advancedMessage);
        advancedLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.commitCombo = new CommitCombo(advancedComposite, 0);
        this.commitCombo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).create());
        advanced.setClient((Control)advancedComposite);
        advanced.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (((Boolean)e.data).booleanValue() && CreateTagDialog.this.commitCombo.getItemCount() == 0) {
                    final ArrayList commits = new ArrayList();
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                CreateTagDialog.this.getRevCommits(commits);
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        Activator.logError(e1.getMessage(), e1);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    for (RevCommit revCommit : commits) {
                        CreateTagDialog.this.commitCombo.add(revCommit);
                    }
                    if (CreateTagDialog.this.existingTag != null) {
                        CreateTagDialog.this.commitCombo.setSelectedElement(CreateTagDialog.this.existingTag.getId());
                    }
                }
                composite.layout(true);
                composite.getShell().pack();
            }
        });
    }

    private void createExistingTagsSection(Composite parent) {
        Composite right = new Composite(parent, 0);
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        right.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        new Label(right, 64).setText(UIText.CreateTagDialog_existingTags);
        Table table = new Table(right, 2820);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(80, 100).create());
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 20));
        table.setLayout((Layout)layout);
        this.tagViewer = new TableViewer(table);
        this.tagViewer.setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        this.tagViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tagViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CreateTagDialog.this.fillTagDialog(event.getSelection());
            }
        });
        this.tagViewer.setComparator(new ViewerComparator(){

            protected Comparator<? super String> getComparator() {
                return CommonUtils.STRING_ASCENDING_COMPARATOR;
            }
        });
        this.tagViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String name;
                if (CreateTagDialog.this.tagNamePattern == null) {
                    return true;
                }
                if (element instanceof String) {
                    return true;
                }
                if (element instanceof Ref) {
                    Ref t = (Ref)element;
                    name = t.getName().substring(10);
                } else if (element instanceof RevTag) {
                    RevTag t = (RevTag)element;
                    name = t.getTagName();
                } else {
                    return true;
                }
                return CreateTagDialog.this.tagNamePattern.matcher(name).find();
            }
        });
        this.tagViewer.setInput((Object)new String[]{UIText.CreateTagDialog_LoadingMessageText});
        this.tagViewer.getTable().setEnabled(false);
        CreateTagDialog.applyDialogFont((Control)parent);
    }

    private void validateInput() {
        if (this.getShell() == null) {
            return;
        }
        String tagNameMessage = this.tagNameValidator.isValid(this.tagNameText.getText());
        this.setErrorMessage(tagNameMessage);
        String tagMessageVal = this.tagMessageText.getText().trim();
        boolean isLightWeight = tagMessageVal.isEmpty();
        Button button = this.getButton(0);
        if (button != null) {
            boolean containsTagNameAndMessage = (tagNameMessage == null || tagMessageVal.length() == 0) && tagMessageVal.length() != 0;
            boolean shouldOverwriteTag = this.overwriteButton.getSelection() && Repository.isValidRefName((String)("refs/tags/" + this.tagNameText.getText()));
            boolean enabled = containsTagNameAndMessage || shouldOverwriteTag || isLightWeight && tagNameMessage == null && !this.tagNameText.getText().isEmpty();
            button.setEnabled(enabled);
            Button createTagAndStartPush = this.getButton(23);
            if (createTagAndStartPush != null) {
                createTagAndStartPush.setEnabled(enabled);
            }
        }
        boolean existingTagSelected = this.existingTag != null;
        boolean readOnly = existingTagSelected && !this.overwriteButton.getSelection();
        this.tagMessageText.getTextWidget().setEditable(!readOnly);
        this.overwriteButton.setEnabled(existingTagSelected);
        if (!existingTagSelected) {
            this.overwriteButton.setSelection(false);
        }
    }

    private void fillTagDialog(ISelection actSelection) {
        IStructuredSelection selection = (IStructuredSelection)actSelection;
        Object firstSelected = selection.getFirstElement();
        this.setExistingTag(firstSelected);
    }

    private void setExistingTagFromText(String tagName) {
        block13: {
            try {
                ObjectId tagObjectId;
                Ref tagRef = this.repo.exactRef("refs/tags/" + tagName);
                if (tagRef == null || (tagObjectId = tagRef.getObjectId()) == null) break block13;
                Throwable throwable = null;
                Object var5_7 = null;
                try (RevWalk revWalk = new RevWalk(this.repo);){
                    RevObject tagObject = revWalk.parseAny((AnyObjectId)tagObjectId);
                    if (tagObject.getType() == 4) {
                        this.setExistingTag(tagObject);
                    } else {
                        this.setExistingTag(tagRef);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return;
            }
            catch (IOException | RevisionSyntaxException throwable) {
                // empty catch block
            }
        }
        this.setNoExistingTag();
    }

    private void setNoExistingTag() {
        this.existingTag = null;
    }

    private void setExistingTag(Object tagObject) {
        String message;
        if (tagObject instanceof RevTag) {
            this.existingTag = new TagWrapper((RevTag)tagObject);
        } else if (tagObject instanceof Ref) {
            this.existingTag = new TagWrapper((Ref)tagObject);
        } else {
            this.setNoExistingTag();
            return;
        }
        String newText = this.existingTag.getName();
        String oldText = this.tagNameText.getText();
        if (!oldText.equals(newText)) {
            int oldCaretPos = this.tagNameText.getSelection().y;
            this.tagNameText.setText(newText);
            if (oldCaretPos == oldText.length() || oldCaretPos > newText.length()) {
                this.tagNameText.setSelection(newText.length());
            } else {
                this.tagNameText.setSelection(oldCaretPos);
            }
        }
        if (this.commitCombo != null) {
            this.commitCombo.setSelectedElement(this.existingTag.getId());
        }
        this.tagMessageText.setText((message = this.existingTag.getMessage()) != null ? message : "");
    }

    private void getRevCommits(Collection<RevCommit> commits) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                RevCommit commit;
                revWalk.sort(RevSort.COMMIT_TIME_DESC, true);
                revWalk.sort(RevSort.BOUNDARY, true);
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId != null) {
                    revWalk.markStart(revWalk.parseCommit((AnyObjectId)headId));
                }
                long count = 0L;
                while ((commit = revWalk.next()) != null && count < 1000L) {
                    commits.add(commit);
                    ++count;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.TagAction_errorWhileGettingRevCommits, e);
            this.setErrorMessage(UIText.TagAction_errorWhileGettingRevCommits);
        }
    }

    private List<Object> getRevTags() throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        List refs = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
        for (Ref ref : refs) {
            RevObject any;
            try {
                any = this.rw.parseAny((AnyObjectId)this.repo.resolve(ref.getName()));
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                break;
            }
            if (any instanceof RevTag) {
                result.add(any);
                continue;
            }
            result.add(ref);
        }
        return result;
    }

    private static class TagLabelProvider
    extends LabelProvider {
        private final Image IMG_TAG = UIIcons.TAG_ANNOTATED.createImage();
        private final Image IMG_LIGHTTAG = UIIcons.TAG.createImage();

        private TagLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof Ref) {
                return this.IMG_LIGHTTAG;
            }
            return this.IMG_TAG;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof Ref) {
                return ((Ref)element).getName().substring(10);
            }
            return ((RevTag)element).getTagName();
        }

        public void dispose() {
            this.IMG_TAG.dispose();
            this.IMG_LIGHTTAG.dispose();
            super.dispose();
        }
    }

    private static class TagWrapper {
        RevTag annotatedTag;
        Ref lightweightTag;

        TagWrapper(RevTag t) {
            this.annotatedTag = t;
            this.lightweightTag = null;
        }

        TagWrapper(Ref l) {
            this.annotatedTag = null;
            this.lightweightTag = l;
        }

        public String getName() {
            if (this.annotatedTag != null) {
                return this.annotatedTag.getTagName();
            }
            return this.lightweightTag.getName().replaceFirst("^refs/tags/", "");
        }

        public ObjectId getId() {
            if (this.annotatedTag != null) {
                return this.annotatedTag.getObject();
            }
            return this.lightweightTag.getObjectId();
        }

        public String getMessage() {
            if (this.annotatedTag != null) {
                return this.annotatedTag.getFullMessage();
            }
            return null;
        }
    }
}

