/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AddExceptionTypeDialogExtension;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddExceptionAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String CAUGHT_CHECKED = "caughtChecked";
    public static final String UNCAUGHT_CHECKED = "uncaughtChecked";
    public static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private IWorkbenchWindow fWindow = null;

    public void run(IAction action) {
        try {
            IDialogSettings settings = this.getDialogSettings();
            AddExceptionTypeDialogExtension ext = new AddExceptionTypeDialogExtension(settings.getBoolean(CAUGHT_CHECKED), settings.getBoolean(UNCAUGHT_CHECKED));
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (IRunnableContext)this.fWindow, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false, (String)"*Exception*", (TypeSelectionExtension)ext);
            dialog.setTitle(BreakpointMessages.AddExceptionAction_0);
            dialog.setMessage(BreakpointMessages.AddExceptionAction_1);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), IJavaDebugHelpContextIds.ADD_EXCEPTION_DIALOG);
            if (dialog.open() == 0) {
                boolean caught = ext.shouldHandleCaughtExceptions();
                boolean uncaught = ext.shouldHandleUncaughtExceptions();
                Object[] results = dialog.getResult();
                if (results != null && results.length > 0) {
                    try {
                        this.createBreakpoint(caught, uncaught, (IType)results[0]);
                        settings.put(CAUGHT_CHECKED, caught);
                        settings.put(UNCAUGHT_CHECKED, uncaught);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.statusDialog(e.getStatus());
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings allSetttings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = allSetttings.addNewSection(DIALOG_SETTINGS);
            section.put(CAUGHT_CHECKED, true);
            section.put(UNCAUGHT_CHECKED, true);
        }
        return section;
    }

    private void createBreakpoint(final boolean caught, final boolean uncaught, final IType type) throws CoreException {
        final IResource resource = BreakpointUtils.getBreakpointResource((IMember)type);
        final HashMap<String, Object> map = new HashMap<String, Object>(10);
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        IJavaExceptionBreakpoint breakpoint = null;
        boolean exists = false;
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName;
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof IJavaExceptionBreakpoint && (typeName = (breakpoint = (IJavaExceptionBreakpoint)b).getTypeName()) != null && typeName.equals(type.getFullyQualifiedName())) {
                exists = true;
                break;
            }
            ++n2;
        }
        if (!exists) {
            Job job = new Job(BreakpointMessages.AddExceptionAction_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        JDIDebugModel.createExceptionBreakpoint((IResource)resource, (String)type.getFullyQualifiedName(), (boolean)caught, (boolean)uncaught, (boolean)AddExceptionAction.isChecked(type), (boolean)true, (Map)map);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            };
            job.setSystem(true);
            job.setPriority(10);
            job.schedule();
        } else {
            IJavaExceptionBreakpoint existingBreakpoint = breakpoint;
            Job job = new Job(BreakpointMessages.AddExceptionAction_EnableExceptionBreakpoint, (IJavaBreakpoint)existingBreakpoint){
                private final /* synthetic */ IJavaBreakpoint val$existingBreakpoint;
                {
                    this.val$existingBreakpoint = iJavaBreakpoint;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        this.val$existingBreakpoint.setEnabled(true);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            };
            job.setSystem(true);
            job.setPriority(10);
            job.schedule();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isChecked(IType type) {
        if (type == null) return true;
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType curr = type;
            while (true) {
                if (curr == null) {
                    return true;
                }
                String name = curr.getFullyQualifiedName('.');
                if ("java.lang.RuntimeException".equals(name)) return false;
                if ("java.lang.Error".equals(name)) {
                    return false;
                }
                curr = hierarchy.getSuperclass(curr);
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return true;
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }
}

