/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileNameFilter
extends ViewerFilter {
    private final String fTargetName;

    public FileNameFilter(String targetName) {
        this.fTargetName = targetName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.fTargetName.equals(((IFile)element).getName());
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = ((IContainer)element).members();
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, parent, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

