/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.util.PatternConstructor;

public class AvailableFilter
extends ViewerFilter {
    public static final String WILDCARD = "*";
    private Pattern fPattern;
    private final Set<Object> selected;
    private final ILabelProvider labelProvider;

    public AvailableFilter(Set<Object> selected, ILabelProvider labelProvider) {
        this.setPattern(WILDCARD);
        this.selected = selected;
        this.labelProvider = labelProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.selected.contains(element)) {
            return false;
        }
        String displayName = this.labelProvider.getText(element);
        return this.matches(element.toString()) || this.matches(displayName);
    }

    private boolean matches(String s) {
        return this.fPattern.matcher(s.toLowerCase()).matches();
    }

    public boolean setPattern(String pattern) {
        String oldPattern;
        Object newPattern = pattern.toLowerCase();
        if (!((String)newPattern).endsWith(WILDCARD)) {
            newPattern = (String)newPattern + WILDCARD;
        }
        if (!((String)newPattern).startsWith(WILDCARD)) {
            newPattern = WILDCARD + (String)newPattern;
        }
        if (this.fPattern != null && ((String)newPattern).equals(oldPattern = this.fPattern.pattern())) {
            return false;
        }
        this.fPattern = PatternConstructor.createPattern((String)newPattern, (boolean)true);
        return true;
    }
}

