/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.java.SearchRepositoriesForIUProposal;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.TextEdit;

public class JavaResolutionFactory {
    public static final int TYPE_JAVA_COMPLETION = 1;
    public static final int TYPE_CLASSPATH_FIX = 2;

    public static final Object createRequireBundleProposal(IProject project, ExportPackageDescription desc, int type, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
        if (desc.getSupplier() == null) {
            return null;
        }
        RequireBundleManifestChange change = new RequireBundleManifestChange(project, desc, cu, qualifiedTypeToImport);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    public static final Object createRequireBundleProposal(IProject project, String desc, int type, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
        if (desc == null) {
            return null;
        }
        RequireBundleManifestChange change = new RequireBundleManifestChange(project, desc, cu, qualifiedTypeToImport);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    public static final Object createImportPackageProposal(IProject project, ExportPackageDescription desc, int type, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
        ImportPackageManifestChange change = new ImportPackageManifestChange(project, desc, cu, qualifiedTypeToImport);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    public static final IJavaCompletionProposal createSearchRepositoriesProposal(String packageName) {
        return new SearchRepositoriesForIUProposal(packageName);
    }

    public static final Object createExportPackageProposal(IProject project, IPackageFragment pkg, int type, int relevance) {
        ExportPackageChange change = new ExportPackageChange(project, pkg);
        return JavaResolutionFactory.createWrapper(change, type, relevance);
    }

    private static final Object createWrapper(AbstractManifestChange change, int type, int relevance) {
        return switch (type) {
            case 1 -> JavaResolutionFactory.createJavaCompletionProposal(change, relevance);
            case 2 -> JavaResolutionFactory.createClasspathFixProposal(change, relevance);
            default -> null;
        };
    }

    public static final ClasspathFixProcessor.ClasspathFixProposal createClasspathFixProposal(final AbstractManifestChange change, final int relevance) {
        return new ClasspathFixProcessor.ClasspathFixProposal(){

            public Change createChange(IProgressMonitor monitor) throws CoreException {
                return change;
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public int getRelevance() {
                return relevance;
            }
        };
    }

    public static final IJavaCompletionProposal createJavaCompletionProposal(final AbstractManifestChange change, final int relevance) {
        return new IJavaCompletionProposal(){

            public int getRelevance() {
                return relevance;
            }

            public void apply(IDocument document) {
                try {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }

            public String getAdditionalProposalInfo() {
                return change.getDescription();
            }

            public IContextInformation getContextInformation() {
                return null;
            }

            public String getDisplayString() {
                return change.getName();
            }

            public Image getImage() {
                return change.getImage();
            }

            public Point getSelection(IDocument document) {
                return null;
            }
        };
    }

    private static abstract class AbstractManifestChange
    extends Change {
        private final Object fChangeObject;
        private final IProject fProject;
        private CompilationUnit fCompilationUnit;
        private String fQualifiedTypeToImport;

        private AbstractManifestChange(IProject project, Object obj) {
            this.fProject = project;
            this.fChangeObject = obj;
        }

        public AbstractManifestChange(IProject project, Object changeObj, CompilationUnit cu, String qualifiedTypeToImport) {
            this(project, changeObj);
            this.fCompilationUnit = cu;
            this.fQualifiedTypeToImport = qualifiedTypeToImport;
        }

        protected Object getChangeObject() {
            return this.fChangeObject;
        }

        protected IProject getProject() {
            return this.fProject;
        }

        protected CompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }

        protected String getQualifiedTypeToImport() {
            return this.fQualifiedTypeToImport;
        }

        public abstract Image getImage();

        public abstract String getDescription();

        protected boolean isUndo() {
            return false;
        }

        protected void insertImport(CompilationUnit compilationUnit, String qualifiedTypeToImport, IProgressMonitor pm) throws CoreException {
            if (compilationUnit == null || qualifiedTypeToImport == null) {
                return;
            }
            ImportRewrite rewrite = ImportRewrite.create((CompilationUnit)compilationUnit, (boolean)true);
            if (rewrite == null) {
                return;
            }
            if (!this.isUndo()) {
                rewrite.addImport(qualifiedTypeToImport);
            } else {
                rewrite.removeImport(qualifiedTypeToImport);
            }
            TextEdit rewriteImports = rewrite.rewriteImports(pm);
            ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement().getAdapter(IOpenable.class);
            this.performTextEdit(rewriteImports, (IFile)iCompilationUnit.getResource(), pm);
        }

        private void performTextEdit(TextEdit textEdit, IFile file, IProgressMonitor pm) throws CoreException {
            TextFileChange textFileChange = new TextFileChange("Add import for " + this.fQualifiedTypeToImport, file);
            textFileChange.setSaveMode(1);
            textFileChange.setEdit(textEdit);
            textFileChange.perform(pm);
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public Object getModifiedElement() {
            return this.getProject();
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }
    }

    private static class ExportPackageChange
    extends AbstractManifestChange {
        public ExportPackageChange(IProject project, IPackageFragment fragment) {
            super(project, fragment);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            ModelModification mod = new ModelModification(this.getProject()){

                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (model instanceof IBundlePluginModelBase) {
                        IBundle bundle = ((IBundlePluginModelBase)model).getBundleModel().getBundle();
                        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        if (header == null) {
                            bundle.setHeader("Export-Package", "");
                            header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
                        }
                        header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, (IPackageFragment)this.getChangeObject(), "version"));
                    }
                }
            };
            PDEModelUtility.modifyModel(mod, (IProgressMonitor)new NullProgressMonitor());
            return null;
        }

        public String getName() {
            return NLS.bind((String)PDEUIMessages.ForbiddenAccessProposal_quickfixMessage, (Object[])new String[]{((IPackageFragment)this.getChangeObject()).getElementName(), this.getProject().getName()});
        }

        @Override
        public Image getImage() {
            return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_BUNDLE);
        }

        @Override
        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class ImportPackageManifestChange
    extends AbstractManifestChange {
        private ImportPackageManifestChange(IProject project, ExportPackageDescription desc) {
            super(project, desc);
        }

        private ImportPackageManifestChange(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
            super(project, desc, cu, qualifiedTypeToImport);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    void base;
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase iBundlePluginModelBase = (IBundlePluginModelBase)model;
                    IBundle bundle = base.getBundleModel().getBundle();
                    ExportPackageDescription desc = (ExportPackageDescription)this.getChangeObject();
                    String pkgId = desc.getName();
                    IManifestHeader header = bundle.getManifestHeader("Import-Package");
                    if (header == null) {
                        header = bundle.getModel().getFactory().createHeader("Import-Package", pkgId);
                    }
                    if (header instanceof ImportPackageHeader) {
                        ImportPackageHeader ipHeader = (ImportPackageHeader)header;
                        String versionAttr = BundlePluginBase.getBundleManifestVersion((IBundle)bundle) < 2 ? "specification-version" : "version";
                        ImportPackageObject impObject = new ImportPackageObject((ManifestHeader)ipHeader, desc, versionAttr);
                        if (!this.isUndo()) {
                            ipHeader.addPackage((PackageObject)impObject);
                        } else {
                            ipHeader.removePackage((PackageObject)impObject);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            this.insertImport(this.getCompilationUnit(), this.getQualifiedTypeToImport(), pm);
            if (!this.isUndo()) {
                return new ImportPackageManifestChange(this.getProject(), (ExportPackageDescription)this.getChangeObject()){

                    @Override
                    public boolean isUndo() {
                        return true;
                    }
                };
            }
            return null;
        }

        @Override
        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_5;
        }

        @Override
        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUNDLE_OBJ);
        }

        public String getName() {
            if (!this.isUndo()) {
                return MessageFormat.format(PDEUIMessages.UnresolvedImportFixProcessor_3, ((ExportPackageDescription)this.getChangeObject()).getName());
            }
            return MessageFormat.format(PDEUIMessages.UnresolvedImportFixProcessor_4, ((ExportPackageDescription)this.getChangeObject()).getName());
        }

        @Override
        public Object getModifiedElement() {
            IFile file = PDEProject.getManifest((IProject)this.getProject());
            if (file.exists()) {
                return file;
            }
            return super.getModifiedElement();
        }
    }

    private static class RequireBundleManifestChange
    extends AbstractManifestChange {
        private RequireBundleManifestChange(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
            super(project, desc, cu, qualifiedTypeToImport);
        }

        private RequireBundleManifestChange(IProject project, String desc, CompilationUnit cu, String qualifiedTypeToImport) {
            super(project, desc, cu, qualifiedTypeToImport);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            PDEModelUtility.modifyModel(new ModelModification(this.getProject()){

                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    if (!(model instanceof IPluginModelBase)) {
                        return;
                    }
                    IPluginModelBase iPluginModelBase = (IPluginModelBase)model;
                    String[] pluginIdStrings = null;
                    if ("JUnit 5 bundles".equals(this.getChangeObject())) {
                        pluginIdStrings = this.getJUnit5Bundles();
                    }
                    if (this.getChangeObject() instanceof ExportPackageDescription) {
                        pluginIdStrings = new String[]{((ExportPackageDescription)this.getChangeObject()).getSupplier().getSymbolicName()};
                    }
                    int i = 0;
                    while (i < pluginIdStrings.length) {
                        String pluginId = pluginIdStrings[i];
                        if (!this.isUndo()) {
                            imports = base.getPluginBase().getImports();
                            boolean duplicate = false;
                            IPluginImport[] iPluginImportArray = imports;
                            int n = imports.length;
                            var10_12 = 0;
                            while (var10_12 < n) {
                                IPluginImport iPluginImport = iPluginImportArray[var10_12];
                                if (iPluginImport.getId().equals(pluginId)) {
                                    duplicate = true;
                                    break;
                                }
                                ++var10_12;
                            }
                            if (!duplicate) {
                                IPluginImport impt = base.getPluginFactory().createImport();
                                impt.setId(pluginId);
                                base.getPluginBase().add(impt);
                            }
                        } else {
                            IPluginImport[] iPluginImportArray = imports = base.getPluginBase().getImports();
                            var10_12 = imports.length;
                            int n = 0;
                            while (n < var10_12) {
                                IPluginImport pluginImport = iPluginImportArray[n];
                                if (pluginImport.getId().equals(pluginId)) {
                                    base.getPluginBase().remove(pluginImport);
                                }
                                ++n;
                            }
                        }
                        ++i;
                    }
                }

                private String[] getJUnit5Bundles() {
                    return new String[]{"org.junit", "junit-jupiter-api"};
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            this.insertImport(this.getCompilationUnit(), this.getQualifiedTypeToImport(), pm);
            if (!this.isUndo()) {
                if (this.getChangeObject() instanceof ExportPackageDescription) {
                    return new RequireBundleManifestChange(this.getProject(), (ExportPackageDescription)this.getChangeObject(), this.getCompilationUnit(), this.getQualifiedTypeToImport()){

                        @Override
                        public boolean isUndo() {
                            return true;
                        }
                    };
                }
                if (this.getChangeObject() instanceof String) {
                    return new RequireBundleManifestChange(this.getProject(), (String)this.getChangeObject(), this.getCompilationUnit(), this.getQualifiedTypeToImport()){

                        @Override
                        public boolean isUndo() {
                            return true;
                        }
                    };
                }
            }
            return null;
        }

        @Override
        public Image getImage() {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ);
        }

        @Override
        public String getDescription() {
            return PDEUIMessages.UnresolvedImportFixProcessor_2;
        }

        public String getName() {
            if (!this.isUndo()) {
                if (this.getChangeObject() instanceof String) {
                    return MessageFormat.format(PDEUIMessages.UnresolvedImportFixProcessor_0, this.getChangeObject().toString());
                }
                return MessageFormat.format(PDEUIMessages.UnresolvedImportFixProcessor_0, ((ExportPackageDescription)this.getChangeObject()).getExporter().getName());
            }
            return MessageFormat.format(PDEUIMessages.UnresolvedImportFixProcessor_1, ((ExportPackageDescription)this.getChangeObject()).getExporter().getName());
        }

        @Override
        public Object getModifiedElement() {
            IFile[] files;
            IFile[] iFileArray = files = new IFile[]{PDEProject.getManifest((IProject)this.getProject()), PDEProject.getPluginXml((IProject)this.getProject())};
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return file;
                }
                ++n2;
            }
            return super.getModifiedElement();
        }
    }
}

