/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.junit.runner.Description;

public class FailuresFirstSorter
implements Comparator<Description> {
    private final Set<String> failuresList;

    public FailuresFirstSorter(String[] failuresList) {
        this.failuresList = new HashSet<String>(Arrays.asList(failuresList));
    }

    @Override
    public int compare(Description d1, Description d2) {
        boolean d1HasFailures = this.hasFailures(d1);
        boolean d2HasFailures = this.hasFailures(d2);
        if (d1HasFailures) {
            return -1;
        }
        if (d2HasFailures) {
            return 1;
        }
        return 0;
    }

    private boolean hasFailures(Description d) {
        if (this.failuresList.contains(d.getDisplayName())) {
            return true;
        }
        for (Description child : d.getChildren()) {
            if (!this.hasFailures(child)) continue;
            return true;
        }
        return false;
    }
}

