/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.repository;

import aQute.bnd.osgi.resource.CapReqBuilder;
import org.eclipse.pde.bnd.ui.views.repository.SearchPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Requirement;

public class ArbitraryNamespaceSearchPanel
extends SearchPanel {
    private String namespace;
    private String filterStr = "";
    private Control focusControl;
    private Label lblFilterHint;

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label lblInstruction = new Label(container, 16448);
        lblInstruction.setText("Enter a capability namespace and filter expression in OSGi standard format. Refer to OSGi Core specification, section 3.2.7 \"Filter Syntax\".");
        lblInstruction.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        new Label(container, 0).setText("Namespace:");
        Text txtNamespace = new Text(container, 2048);
        if (this.namespace != null) {
            txtNamespace.setText(this.namespace);
        }
        txtNamespace.setLayoutData((Object)new GridData(4, 4, true, false));
        txtNamespace.addModifyListener(e -> {
            this.namespace = txtNamespace.getText().trim();
            this.validate();
        });
        new Label(container, 0).setText("Filter Expression:");
        Label lblSpacer2 = new Label(container, 0);
        Text txtFilter = new Text(container, 2050);
        txtFilter.setMessage("enter OSGi-style filter");
        if (this.filterStr != null) {
            txtFilter.setText(this.filterStr);
        }
        GridData gdArbitrarySearchFilter = new GridData(4, 4, true, true, 2, 1);
        gdArbitrarySearchFilter.heightHint = 50;
        txtFilter.setLayoutData((Object)gdArbitrarySearchFilter);
        txtFilter.addModifyListener(e -> {
            this.filterStr = txtFilter.getText().trim();
            this.validate();
        });
        this.lblFilterHint = new Label(container, 0);
        this.lblFilterHint.setText("Example: (&&(name=value)(version>=1.0))");
        this.lblFilterHint.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.validate();
        this.focusControl = txtNamespace;
        return container;
    }

    private void validate() {
        try {
            if (this.namespace == null || this.namespace.length() == 0) {
                this.setError(null);
                this.setRequirement(null);
                return;
            }
            int i = 0;
            while (i < this.namespace.length()) {
                char c = this.namespace.charAt(i);
                if ('.' == c) {
                    if (i == 0 || i == this.namespace.length() - 1) {
                        throw new IllegalArgumentException("Namespace cannot have leading or trailing '.' character");
                    }
                    if ('.' == this.namespace.charAt(i - 1)) {
                        throw new IllegalArgumentException("Namespace cannot have repeated '.' characters");
                    }
                } else if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') {
                    throw new IllegalArgumentException(String.format("Invalid character in namespace: '%c'", Character.valueOf(c)));
                }
                ++i;
            }
            this.updateFilterExpressionHint(this.namespace);
            CapReqBuilder builder = new CapReqBuilder(this.namespace);
            if (this.filterStr != null && this.filterStr.trim().length() > 0) {
                try {
                    Filter filter = FrameworkUtil.createFilter((String)this.filterStr.trim());
                    builder.filter((CharSequence)filter.toString());
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalArgumentException("Invalid filter string: " + e.getMessage());
                }
            }
            this.setRequirement((Requirement)builder.buildSyntheticRequirement());
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            this.setRequirement(null);
        }
    }

    private void updateFilterExpressionHint(String namespace) {
        String hint = "osgi.service".equals(namespace) ? String.format("(%s=fully-qualified-classname)", "objectClass") : String.format("(&&(%s=value)(version>=1.0))", namespace);
        this.lblFilterHint.setText("Example: " + hint);
    }

    @Override
    public void setFocus() {
        this.focusControl.setFocus();
    }

    public void saveState(IMemento memento) {
        memento.putString("namespace", this.namespace);
        memento.putString("filter", this.filterStr);
    }

    @Override
    public void restoreState(IMemento memento) {
        this.namespace = memento.getString("namespace");
        this.filterStr = memento.getString("filter");
    }
}

