/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileExtensionFilter
extends ViewerFilter {
    private final String[] extensions;
    private final boolean caseInsensitive;

    public FileExtensionFilter(String[] extensions, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.extensions = new String[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            this.extensions[i] = extensions[i].length() > 0 && extensions[i].charAt(0) == '.' ? extensions[i] : "." + extensions[i];
            if (caseInsensitive) {
                this.extensions[i] = this.extensions[i].toLowerCase();
            }
            ++i;
        }
    }

    public FileExtensionFilter(String extension, boolean caseInsensitive) {
        this(new String[]{extension}, caseInsensitive);
    }

    public FileExtensionFilter(String[] extensions) {
        this(extensions, true);
    }

    public FileExtensionFilter(String extension) {
        this(extension, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            String fileName = ((IFile)element).getName();
            if (this.caseInsensitive) {
                fileName = fileName.toLowerCase(Locale.ENGLISH);
            }
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileName.endsWith(extension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = ((IContainer)element).members();
                int n = resources.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource element2 = iResourceArray[n3];
                    if (this.select(viewer, parent, element2)) {
                        return true;
                    }
                    ++n3;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

