/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree;

import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.verifications.tree.VerifyTreeData;

public class TreeVerificationUtils {
    public static String getDecoratedImagePath(Image img) {
        if (img == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(img.getPath());
        for (Image decorImg : img.getDecorations()) {
            sb.append('_').append(decorImg.getPath());
        }
        return sb.toString();
    }

    public static boolean isExcludedColumn(VerifyTreeData tree, int ind) {
        EList<Integer> excludedColumns = tree.getExcludedColumns();
        return excludedColumns.contains(ind);
    }

    public static void addExcludedColumn(VerifyTreeData tree, int excludedColumnIndex) {
        tree.getExcludedColumns().add((Object)excludedColumnIndex);
    }

    public static void removeExcludedColumn(VerifyTreeData tree, int excludedColumnIndex) {
        EList<Integer> excludedColumns = tree.getExcludedColumns();
        int index = excludedColumns.indexOf(excludedColumnIndex);
        excludedColumns.remove(index);
    }
}

