/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class ResetWithPrototypeValuesAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_RESET_WITH_PROTOTYPE_VALUES_ACTION = DebugUIPlugin.getUniqueIdentifier() + ".ID_RESET_WITH_PROTOTYPE_VALUES_ACTION";

    public ResetWithPrototypeValuesAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.ResetWithPrototypeValuesAction_Reset_with_prototype_values_1, viewer, mode);
    }

    @Override
    protected void performAction() {
        try {
            for (Object launchConfiguration : this.getStructuredSelection().toList()) {
                ILaunchConfigurationDialog dialog;
                if (!(launchConfiguration instanceof ILaunchConfiguration)) continue;
                ILaunchConfigurationWorkingCopy workingCopy = ((ILaunchConfiguration)launchConfiguration).getWorkingCopy();
                workingCopy.setPrototype(((ILaunchConfiguration)launchConfiguration).getPrototype(), true);
                workingCopy.doSave();
                if (this.getStructuredSelection().size() != 1 || !((dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog()) instanceof LaunchConfigurationsDialog)) continue;
                ((LaunchConfigurationsDialog)dialog).getTabViewer().setInput(workingCopy);
            }
        }
        catch (CoreException e) {
            this.errorDialog(e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean onlyLaunchConfigurationWithPrototypeSelected = false;
        for (Object object : selection.toList()) {
            if (object instanceof ILaunchConfiguration) {
                if (((ILaunchConfiguration)object).isPrototype()) {
                    return false;
                }
                try {
                    if (((ILaunchConfiguration)object).getPrototype() != null) {
                        onlyLaunchConfigurationWithPrototypeSelected = true;
                        continue;
                    }
                    return false;
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    continue;
                }
            }
            return false;
        }
        return onlyLaunchConfigurationWithPrototypeSelected;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_DLCL_RESET_PROTO");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_ELCL_RESET_PROTO");
    }

    public String getToolTipText() {
        return LaunchConfigurationsMessages.LaunchConfigurationsDialog_9;
    }
}

