/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringPropertyPage;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringHistoryEditHelper {
    private static IProject[] getAffectedProjects(RefactoringDescriptorProxy[] descriptors) {
        HashSet<String> set = new HashSet<String>();
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptorProxy descriptor = refactoringDescriptorProxyArray[n2];
            String project = descriptor.getProject();
            if (project == null || "".equals(project)) {
                return null;
            }
            set.add(project);
            ++n2;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] result = new IProject[set.size()];
        int index = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            result[index] = root.getProject((String)iterator.next());
            ++index;
        }
        return result;
    }

    public static void promptRefactoringDelete(Shell shell, IRunnableContext context, IRefactoringHistoryControl control, IRefactoringDescriptorDeleteQuery query, IRefactoringHistoryProvider provider, RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)query);
        Assert.isNotNull((Object)provider);
        Assert.isNotNull((Object)descriptors);
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            try {
                IProject[] affected = RefactoringHistoryEditHelper.getAffectedProjects(descriptors);
                context.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, (int)300);
                    try {
                        try {
                            service.deleteRefactoringDescriptors(descriptors, query, (IProgressMonitor)subMonitor.newChild(280, 1));
                        }
                        catch (CoreException exception) {
                            Throwable throwable = exception.getStatus().getException();
                            if (throwable instanceof IOException) {
                                shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage()));
                            }
                            throw exception;
                        }
                        if (query.hasDeletions()) {
                            RefactoringHistory history = provider.getRefactoringHistory((IProgressMonitor)subMonitor.newChild(20, 1));
                            shell.getDisplay().syncExec(() -> {
                                control.setInput(history);
                                control.setCheckedDescriptors(RefactoringPropertyPage.EMPTY_DESCRIPTORS);
                            });
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                }, (ISchedulingRule)(affected == null ? ResourcesPlugin.getWorkspace().getRoot() : new MultiRule((ISchedulingRule[])affected))));
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            service.disconnect();
        }
    }

    private RefactoringHistoryEditHelper() {
    }

    public static interface IRefactoringHistoryProvider {
        public RefactoringHistory getRefactoringHistory(IProgressMonitor var1);
    }
}

