/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

class FeatureTable {
    private final Map<IFeatureModel, Idver> fModel2idver = new HashMap<IFeatureModel, Idver>();
    private final Map<Idver, List<IFeatureModel>> fIdver2models = new HashMap<Idver, List<IFeatureModel>>();
    private final Map<String, List<Idver>> fId2idvers = new HashMap<String, List<Idver>>();

    FeatureTable() {
    }

    public synchronized Idver get(IFeatureModel model) {
        return this.fModel2idver.get(model);
    }

    public List<IFeatureModel> get(String id, String version) {
        return this.get(new Idver(id, version));
    }

    public synchronized List<IFeatureModel> get(Idver idver) {
        List<IFeatureModel> models = this.fIdver2models.get(idver);
        if (models == null) {
            return List.of();
        }
        return List.copyOf(models);
    }

    public synchronized List<IFeatureModel> getAllValidFeatures(String id) {
        List<Idver> idvers = this.fId2idvers.get(id);
        if (idvers == null) {
            return List.of();
        }
        return idvers.stream().map(this.fIdver2models::get).filter(Objects::nonNull).flatMap(Collection::stream).filter(IBaseModel::isValid).toList();
    }

    public synchronized IFeatureModel[] getAllValidFeatures() {
        return (IFeatureModel[])this.fModel2idver.keySet().stream().filter(IBaseModel::isValid).toArray(IFeatureModel[]::new);
    }

    public synchronized Idver remove(IFeatureModel model) {
        return this.removeImpl(model);
    }

    private Idver removeImpl(IFeatureModel model) {
        Idver idver = this.fModel2idver.remove(model);
        if (idver == null) {
            return null;
        }
        if (FeatureTable.removeValueFromMultimap(this.fIdver2models, idver, model)) {
            FeatureTable.removeValueFromMultimap(this.fId2idvers, idver.id(), idver);
        }
        return idver;
    }

    private static <K, V> boolean removeValueFromMultimap(Map<K, List<V>> map, K key, V value) {
        return map.computeIfPresent(key, (k, values) -> {
            values.remove(value);
            return values.isEmpty() ? null : values;
        }) == null;
    }

    public synchronized Idver add(IFeatureModel model) {
        this.removeImpl(model);
        IFeature feature = model.getFeature();
        String id = feature.getId();
        String ver = feature.getVersion();
        Idver idver = new Idver(id, ver);
        this.fModel2idver.put(model, idver);
        List models = this.fIdver2models.computeIfAbsent(idver, iv -> new ArrayList(1));
        models.add(model);
        List idvers = this.fId2idvers.computeIfAbsent(id, i -> new ArrayList(1));
        idvers.add(idver);
        return idver;
    }

    public synchronized String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (IFeatureModel model : this.fModel2idver.keySet()) {
            IFeature feature = model.getFeature();
            String str = String.valueOf(this.get(model)) + "@" + feature.getId() + "_" + feature.getVersion();
            joiner.add(str);
        }
        return joiner.toString();
    }

    record Idver(String id, String version) {
    }
}

