/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.QueryResult;

public abstract class SearchPattern
implements ISearchPattern {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        List<QueryResult> results = index.query(this.getKeys(), this.getPattern(), monitor);
        IPath path = index.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (QueryResult queryResult : results) {
            Path fullPath = new Path(queryResult.path);
            IQ7Element q7Element = RcpttCore.create(root.findMember(path.append((IPath)fullPath)));
            IIndexRequestor iIndexRequestor = requestor;
            synchronized (iIndexRequestor) {
                requestor.acceptMatch(q7Element, queryResult.key, queryResult.value);
            }
        }
    }

    public abstract IKeyQuery getPattern();

    public abstract String[] getKeys();

    public static interface IKeyQuery {
        public boolean accept(String var1, String var2);
    }
}

